/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.blockentity;

import com.piglinmine.fastpipes.FPipesBlockEntities;
import com.piglinmine.fastpipes.FPipesBlocks;
import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipe;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipeType;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransport;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransportProps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemPipeBlockEntity
extends PipeBlockEntity {
    private ItemPipeType type;
    private List<ItemTransportProps> props = new ArrayList<ItemTransportProps>();

    public ItemPipeBlockEntity(BlockPos pos, BlockState state) {
        super(ItemPipeBlockEntity.getBlockEntityType(state), pos, state);
        this.type = ItemPipeBlockEntity.getItemPipeType(state);
    }

    private static BlockEntityType<?> getBlockEntityType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_ITEM_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.BASIC_ITEM_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_ITEM_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.IMPROVED_ITEM_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_ITEM_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ADVANCED_ITEM_PIPE.get();
        }
        return (BlockEntityType)FPipesBlockEntities.BASIC_ITEM_PIPE.get();
    }

    private static ItemPipeType getItemPipeType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_ITEM_PIPE.get()) {
            return ItemPipeType.BASIC;
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_ITEM_PIPE.get()) {
            return ItemPipeType.IMPROVED;
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_ITEM_PIPE.get()) {
            return ItemPipeType.ADVANCED;
        }
        return ItemPipeType.BASIC;
    }

    public static void tick(ItemPipeBlockEntity blockEntity) {
        blockEntity.props.forEach(ItemTransportProps::tick);
    }

    public List<ItemTransportProps> getProps() {
        return this.props;
    }

    public void setProps(List<ItemTransportProps> props) {
        this.props = props;
    }

    public IItemHandler getItemHandler(Direction side) {
        return null;
    }

    @Override
    protected void spawnDrops(Pipe pipe) {
        super.spawnDrops(pipe);
        if (pipe instanceof ItemPipe) {
            ItemPipe itemPipe = (ItemPipe)pipe;
            for (ItemTransport transport : itemPipe.getTransports()) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)transport.getStack());
            }
        }
    }

    @Override
    protected Pipe createPipe(Level level, BlockPos pos) {
        return new ItemPipe(level, pos, this.type);
    }
}

