/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.blockentity;

import com.piglinmine.fastpipes.blockentity.BaseBlockEntity;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentManager;
import com.piglinmine.fastpipes.network.pipe.attachment.ClientAttachmentManager;
import com.piglinmine.fastpipes.network.pipe.attachment.DummyAttachmentManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public abstract class PipeBlockEntity
extends BaseBlockEntity {
    public static final ModelProperty<ResourceLocation[]> ATTACHMENTS_PROPERTY = new ModelProperty();
    private final AttachmentManager clientAttachmentManager = new ClientAttachmentManager();
    private boolean unloaded;

    protected PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AttachmentManager getAttachmentManager() {
        if (this.level.isClientSide) {
            return this.clientAttachmentManager;
        }
        Pipe pipe = NetworkManager.get(this.level).getPipe(this.worldPosition);
        if (pipe != null) {
            return pipe.getAttachmentManager();
        }
        return DummyAttachmentManager.INSTANCE;
    }

    public void clearRemoved() {
        NetworkManager mgr;
        super.clearRemoved();
        if (!this.level.isClientSide && (mgr = NetworkManager.get(this.level)).getPipe(this.worldPosition) == null) {
            mgr.addPipe(this.createPipe(this.level, this.worldPosition));
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && !this.unloaded) {
            NetworkManager mgr = NetworkManager.get(this.level);
            Pipe pipe = mgr.getPipe(this.worldPosition);
            if (pipe != null) {
                this.spawnDrops(pipe);
                for (Attachment attachment : pipe.getAttachmentManager().getAttachments()) {
                    Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)attachment.getDrop());
                }
            }
            mgr.removePipe(this.worldPosition);
        }
    }

    protected void spawnDrops(Pipe pipe) {
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ATTACHMENTS_PROPERTY, (Object)this.getAttachmentManager().getState()).build();
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag, HolderLookup.Provider registries) {
        this.getAttachmentManager().writeUpdate(tag);
        return super.writeUpdate(tag, registries);
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag, HolderLookup.Provider registries) {
        super.readUpdate(tag, registries);
        this.getAttachmentManager().readUpdate(tag);
        this.requestModelDataUpdate();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    protected abstract Pipe createPipe(Level var1, BlockPos var2);
}

