/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.integration.jade;

import com.piglinmine.fastpipes.blockentity.EnergyPipeBlockEntity;
import com.piglinmine.fastpipes.integration.jade.FastPipesJadePlugin;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipe;
import com.piglinmine.fastpipes.network.pipe.energy.ServerEnergyPipeEnergyStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum EnergyPipeComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag serverData = accessor.getServerData();
        if (serverData.contains("EnergyStored") && serverData.contains("MaxEnergyStored") && serverData.contains("TransferRate")) {
            int transferRate = serverData.getInt("TransferRate");
            tooltip.add((Component)Component.translatable((String)"jade.fastpipes.transfer_rate", (Object[])new Object[]{transferRate}));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof EnergyPipeBlockEntity) {
            EnergyPipeBlockEntity energyPipeBlockEntity = (EnergyPipeBlockEntity)blockEntity;
            NetworkManager networkManager = NetworkManager.get(accessor.getLevel());
            Pipe pipe = networkManager.getPipe(accessor.getPosition());
            if (pipe instanceof EnergyPipe) {
                EnergyPipe energyPipe = (EnergyPipe)pipe;
                ServerEnergyPipeEnergyStorage energyStorage = energyPipe.getEnergyStorage();
                if (energyStorage != null) {
                    data.putInt("EnergyStored", energyStorage.getEnergyStored());
                    data.putInt("MaxEnergyStored", energyStorage.getMaxEnergyStored());
                    data.putInt("TransferRate", energyStorage.getEnergyPipeType().getTransferRate());
                } else {
                    data.putInt("EnergyStored", 0);
                    data.putInt("MaxEnergyStored", energyPipeBlockEntity.getEnergyPipeType().getCapacity());
                    data.putInt("TransferRate", energyPipeBlockEntity.getEnergyPipeType().getTransferRate());
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return FastPipesJadePlugin.ENERGY_PIPE_INFO;
    }
}

