/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.menu;

import com.piglinmine.fastpipes.menu.slot.FilterSlot;
import com.piglinmine.fastpipes.menu.slot.FluidFilterSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BaseContainerMenu
extends AbstractContainerMenu {
    private final List<FluidFilterSlot> fluidSlots = new ArrayList<FluidFilterSlot>();
    private final Player player;

    protected BaseContainerMenu(@Nullable MenuType<?> type, int windowId, Player player) {
        super(type, windowId);
        this.player = player;
    }

    protected void addPlayerInventory(int xInventory, int yInventory) {
        int x;
        int id = 9;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)this.player.getInventory(), id, xInventory + x * 18, yInventory + y * 18));
                ++id;
            }
        }
        id = 0;
        for (int i = 0; i < 9; ++i) {
            x = xInventory + i * 18;
            int y = yInventory + 4 + 54;
            this.addSlot(new Slot((Container)this.player.getInventory(), id, x, y));
            ++id;
        }
    }

    public void clicked(int id, int dragType, ClickType clickType, Player player) {
        Slot slot = id >= 0 ? this.getSlot(id) : null;
        ItemStack holding = player.containerMenu.getCarried();
        if (slot instanceof FilterSlot) {
            if (holding.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else if (slot.mayPlace(holding)) {
                slot.set(holding.copy());
            }
            return;
        }
        if (slot instanceof FluidFilterSlot) {
            if (holding.isEmpty()) {
                ((FluidFilterSlot)slot).onContainerClicked(ItemStack.EMPTY);
            } else {
                ((FluidFilterSlot)slot).onContainerClicked(holding);
            }
            return;
        }
        super.clicked(id, dragType, clickType, player);
    }

    protected Slot addSlot(Slot slot) {
        if (slot instanceof FluidFilterSlot) {
            this.fluidSlots.add((FluidFilterSlot)slot);
        }
        return super.addSlot(slot);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public List<FluidFilterSlot> getFluidSlots() {
        return this.fluidSlots;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot || slot instanceof FluidFilterSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

