/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.menu;

import com.piglinmine.fastpipes.FPipesContainerMenus;
import com.piglinmine.fastpipes.inventory.fluid.FluidInventory;
import com.piglinmine.fastpipes.menu.BaseContainerMenu;
import com.piglinmine.fastpipes.menu.slot.FilterSlot;
import com.piglinmine.fastpipes.menu.slot.FluidFilterSlot;
import com.piglinmine.fastpipes.network.FastPipesNetwork;
import com.piglinmine.fastpipes.network.message.ChangeBlacklistWhitelistMessage;
import com.piglinmine.fastpipes.network.message.ChangeExactModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeRedstoneModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeRoutingModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeStackSizeMessage;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RoutingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ExtractorAttachmentContainerMenu
extends BaseContainerMenu {
    private final BlockPos pos;
    private final Direction dir;
    private final ExtractorAttachmentType extractorAttachmentType;
    private final boolean fluidMode;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    private BlacklistWhitelist blacklistWhitelist = BlacklistWhitelist.BLACKLIST;
    private RoutingMode routingMode = RoutingMode.NEAREST;
    private int stackSize;
    private boolean exactMode;

    public ExtractorAttachmentContainerMenu(int windowId, Player player, BlockPos pos, Direction dir, RedstoneMode redstoneMode, BlacklistWhitelist blacklistWhitelist, RoutingMode routingMode, int stackSize, boolean exactMode, ExtractorAttachmentType type, ItemStackHandler itemFilter, FluidInventory fluidFilter, boolean fluidMode) {
        super((MenuType)FPipesContainerMenus.EXTRACTOR_ATTACHMENT.get(), windowId, player);
        this.addPlayerInventory(8, 111);
        int x = 44;
        int y = 19;
        for (int i = 1; i <= type.getFilterSlots(); ++i) {
            if (fluidMode) {
                this.addSlot(new FluidFilterSlot(fluidFilter, i - 1, x, y));
            } else {
                this.addSlot((Slot)new FilterSlot((IItemHandler)itemFilter, i - 1, x, y));
            }
            if (i % 5 == 0) {
                x = 44;
                y += 18;
                continue;
            }
            x += 18;
        }
        this.pos = pos;
        this.dir = dir;
        this.extractorAttachmentType = type;
        this.fluidMode = fluidMode;
        this.redstoneMode = redstoneMode;
        this.blacklistWhitelist = blacklistWhitelist;
        this.routingMode = routingMode;
        this.stackSize = stackSize;
        this.exactMode = exactMode;
    }

    public ExtractorAttachmentContainerMenu(int windowId, Player player) {
        this(windowId, player, BlockPos.ZERO, Direction.NORTH, RedstoneMode.IGNORED, BlacklistWhitelist.BLACKLIST, RoutingMode.NEAREST, ExtractorAttachmentType.BASIC.getItemsToExtract(), false, ExtractorAttachmentType.BASIC, new ItemStackHandler(15), new FluidInventory(15), false);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public boolean isFluidMode() {
        return this.fluidMode;
    }

    public ExtractorAttachmentType getExtractorAttachmentType() {
        return this.extractorAttachmentType;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        FastPipesNetwork.sendToServer(new ChangeRedstoneModeMessage(this.pos, this.dir, redstoneMode.ordinal()));
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        this.blacklistWhitelist = blacklistWhitelist;
        FastPipesNetwork.sendToServer(new ChangeBlacklistWhitelistMessage(this.pos, this.dir, blacklistWhitelist == BlacklistWhitelist.BLACKLIST));
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public void setRoutingMode(RoutingMode routingMode) {
        this.routingMode = routingMode;
        FastPipesNetwork.sendToServer(new ChangeRoutingModeMessage(this.pos, this.dir, routingMode.ordinal()));
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
        FastPipesNetwork.sendToServer(new ChangeStackSizeMessage(this.pos, this.dir, stackSize));
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public void setExactMode(boolean exactMode) {
        this.exactMode = exactMode;
        FastPipesNetwork.sendToServer(new ChangeExactModeMessage(this.pos, this.dir, exactMode));
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem() && index < 36) {
            for (int i = 36; i < this.slots.size(); ++i) {
                SlotItemHandler itemSlot;
                Slot filterSlot = (Slot)this.slots.get(i);
                if (filterSlot instanceof FluidFilterSlot) {
                    FluidFilterSlot fluidSlot = (FluidFilterSlot)filterSlot;
                    if (!fluidSlot.getFluidInventory().getFluid(fluidSlot.getSlotIndex()).isEmpty()) continue;
                    break;
                }
                if (!(filterSlot instanceof SlotItemHandler) || (itemSlot = (SlotItemHandler)filterSlot).hasItem()) continue;
                ItemStack toInsert = slot.getItem().copy();
                toInsert.setCount(1);
                boolean foundExistingItem = false;
                for (int j = 0; j < itemSlot.getItemHandler().getSlots(); ++j) {
                    if (!ItemStack.matches((ItemStack)itemSlot.getItemHandler().getStackInSlot(j), (ItemStack)toInsert)) continue;
                    foundExistingItem = true;
                    break;
                }
                if (foundExistingItem) break;
                itemSlot.set(toInsert);
                break;
            }
        }
        return ItemStack.EMPTY;
    }
}

