/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network;

import com.piglinmine.fastpipes.network.message.ChangeBlacklistWhitelistMessage;
import com.piglinmine.fastpipes.network.message.ChangeExactModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeRedstoneModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeRoutingModeMessage;
import com.piglinmine.fastpipes.network.message.ChangeStackSizeMessage;
import com.piglinmine.fastpipes.network.message.FluidFilterSlotUpdateMessage;
import com.piglinmine.fastpipes.network.message.FluidPipeMessage;
import com.piglinmine.fastpipes.network.message.ItemTransportMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class FastPipesNetwork {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        registrar.playToClient(ItemTransportMessage.TYPE, ItemTransportMessage.STREAM_CODEC, ItemTransportMessage::handleClient);
        registrar.playToClient(FluidPipeMessage.TYPE, FluidPipeMessage.STREAM_CODEC, FluidPipeMessage::handleClient);
        registrar.playToClient(FluidFilterSlotUpdateMessage.TYPE, FluidFilterSlotUpdateMessage.STREAM_CODEC, FluidFilterSlotUpdateMessage::handleClient);
        registrar.playToServer(ChangeRedstoneModeMessage.TYPE, ChangeRedstoneModeMessage.STREAM_CODEC, ChangeRedstoneModeMessage::handleServer);
        registrar.playToServer(ChangeBlacklistWhitelistMessage.TYPE, ChangeBlacklistWhitelistMessage.STREAM_CODEC, ChangeBlacklistWhitelistMessage::handleServer);
        registrar.playToServer(ChangeRoutingModeMessage.TYPE, ChangeRoutingModeMessage.STREAM_CODEC, ChangeRoutingModeMessage::handleServer);
        registrar.playToServer(ChangeStackSizeMessage.TYPE, ChangeStackSizeMessage.STREAM_CODEC, ChangeStackSizeMessage::handleServer);
        registrar.playToServer(ChangeExactModeMessage.TYPE, ChangeExactModeMessage.STREAM_CODEC, ChangeExactModeMessage::handleServer);
    }

    public static void sendInArea(Level level, BlockPos pos, int radius, Object message) {
        if (level.isClientSide) {
            return;
        }
        if (message instanceof ItemTransportMessage) {
            ItemTransportMessage msg = (ItemTransportMessage)message;
            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)radius, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof FluidPipeMessage) {
            FluidPipeMessage msg = (FluidPipeMessage)message;
            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)radius, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToServer(Object message) {
        if (message instanceof ChangeRedstoneModeMessage) {
            ChangeRedstoneModeMessage msg = (ChangeRedstoneModeMessage)message;
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof ChangeBlacklistWhitelistMessage) {
            ChangeBlacklistWhitelistMessage msg = (ChangeBlacklistWhitelistMessage)message;
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof ChangeRoutingModeMessage) {
            ChangeRoutingModeMessage msg = (ChangeRoutingModeMessage)message;
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof ChangeStackSizeMessage) {
            ChangeStackSizeMessage msg = (ChangeStackSizeMessage)message;
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof ChangeExactModeMessage) {
            ChangeExactModeMessage msg = (ChangeExactModeMessage)message;
            PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer player, Object message) {
        if (message instanceof ItemTransportMessage) {
            ItemTransportMessage msg = (ItemTransportMessage)message;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof FluidPipeMessage) {
            FluidPipeMessage msg = (FluidPipeMessage)message;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (message instanceof FluidFilterSlotUpdateMessage) {
            FluidFilterSlotUpdateMessage msg = (FluidFilterSlotUpdateMessage)message;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

