/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network;

import com.piglinmine.fastpipes.network.graph.NetworkGraph;
import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerResult;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.DestinationType;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class Network {
    protected final NetworkGraph graph = new NetworkGraph(this);
    private final String id;
    private BlockPos originPos;
    private boolean didDoInitialScan;

    public Network(BlockPos originPos, String id) {
        this.id = id;
        this.originPos = originPos;
    }

    public void setOriginPos(BlockPos originPos) {
        this.originPos = originPos;
    }

    public String getId() {
        return this.id;
    }

    public NetworkGraphScannerResult scanGraph(Level level, BlockPos pos) {
        return this.graph.scan(level, pos);
    }

    public List<Destination> getDestinations(DestinationType type) {
        return this.graph.getDestinations(type);
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putString("id", this.id);
        tag.putLong("origin", this.originPos.asLong());
        return tag;
    }

    public void update(Level level) {
        if (!this.didDoInitialScan) {
            this.didDoInitialScan = true;
            this.scanGraph(level, this.originPos);
        }
        this.graph.getPipes().forEach(Pipe::update);
    }

    public Pipe getPipe(BlockPos pos) {
        return this.graph.getPipes().stream().filter(p -> p.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    public abstract void onMergedWith(Network var1);

    public abstract ResourceLocation getType();
}

