/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.NetworkFactory;
import com.piglinmine.fastpipes.network.NetworkRegistry;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.PipeFactory;
import com.piglinmine.fastpipes.network.pipe.PipeRegistry;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends SavedData {
    private static final String NAME = "fastpipes_networks";
    private static final Logger LOGGER = LogManager.getLogger(NetworkManager.class);
    private final Level level;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private final Map<BlockPos, Pipe> pipes = new HashMap<BlockPos, Pipe>();

    public NetworkManager(Level level) {
        this.level = level;
    }

    public static NetworkManager get(Level level) {
        return NetworkManager.get((ServerLevel)level);
    }

    public static NetworkManager get(ServerLevel level) {
        return (NetworkManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new NetworkManager((Level)level), (tag, provider) -> {
            NetworkManager networkManager = new NetworkManager((Level)level);
            networkManager.load((CompoundTag)tag, (HolderLookup.Provider)provider);
            return networkManager;
        }), NAME);
    }

    public void addNetwork(Network network) {
        if (this.networks.containsKey(network.getId())) {
            throw new RuntimeException("Duplicate network " + network.getId());
        }
        this.networks.put(network.getId(), network);
        LOGGER.debug("Network {} created", (Object)network.getId());
        this.setDirty();
    }

    public void removeNetwork(String id) {
        if (!this.networks.containsKey(id)) {
            throw new RuntimeException("Network " + id + " not found");
        }
        this.networks.remove(id);
        LOGGER.debug("Network {} removed", (Object)id);
        this.setDirty();
    }

    private void formNetworkAt(Level level, BlockPos pos, ResourceLocation type) {
        Network network = NetworkRegistry.INSTANCE.getFactory(type).create(pos);
        this.addNetwork(network);
        network.scanGraph(level, pos);
    }

    public void addPipe(Pipe pipe) {
        if (this.pipes.containsKey(pipe.getPos())) {
            throw new RuntimeException("Pipe at " + String.valueOf(pipe.getPos()) + " already exists");
        }
        this.pipes.put(pipe.getPos(), pipe);
        LOGGER.debug("Pipe added at {}", (Object)pipe.getPos());
        this.setDirty();
        this.tryConnectPipe(pipe);
    }

    private void tryConnectPipe(Pipe pipe) {
        List<Pipe> adjacentPipes = this.findAdjacentPipes(pipe.getPos(), pipe.getNetworkType());
        if (adjacentPipes.isEmpty()) {
            this.formNetworkAt(pipe.getLevel(), pipe.getPos(), pipe.getNetworkType());
        } else {
            this.mergeNetworksIntoOne(adjacentPipes, pipe.getLevel(), pipe.getPos());
        }
    }

    private void mergeNetworksIntoOne(List<Pipe> candidates, Level level, BlockPos pos) {
        if (candidates.isEmpty()) {
            throw new RuntimeException("Cannot merge networks: no candidates");
        }
        HashSet<Network> networkCandidates = new HashSet<Network>();
        for (Pipe candidate : candidates) {
            if (candidate.getNetwork() == null) {
                LOGGER.warn("Pipe at {} has no network, will be handled by network update", (Object)candidate.getPos());
                this.formNetworkAt(candidate.getLevel(), candidate.getPos(), candidate.getNetworkType());
            }
            if (candidate.getNetwork() == null) continue;
            networkCandidates.add(candidate.getNetwork());
        }
        if (networkCandidates.isEmpty()) {
            this.formNetworkAt(level, pos, candidates.get(0).getNetworkType());
            return;
        }
        Iterator networks = networkCandidates.iterator();
        Network mainNetwork = (Network)networks.next();
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        while (networks.hasNext()) {
            Network otherNetwork = (Network)networks.next();
            boolean canMerge = mainNetwork.getType().equals((Object)otherNetwork.getType());
            if (!canMerge) continue;
            mergedNetworks.add(otherNetwork);
            this.removeNetwork(otherNetwork.getId());
        }
        mainNetwork.scanGraph(level, pos);
        mergedNetworks.forEach(n -> n.onMergedWith(mainNetwork));
    }

    private List<Pipe> findAdjacentPipes(BlockPos pos, ResourceLocation networkType) {
        ArrayList<Pipe> adjacentPipes = new ArrayList<Pipe>();
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.relative(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            adjacentPipes.add(pipe);
        }
        return adjacentPipes;
    }

    public void removePipe(BlockPos pos) {
        Pipe pipe = this.getPipe(pos);
        if (pipe == null) {
            throw new RuntimeException("Pipe at " + String.valueOf(pos) + " was not found");
        }
        if (pipe.getNetwork() == null) {
            LOGGER.warn("Removed pipe at {} has no associated network", (Object)pipe.getPos());
        }
        this.pipes.remove(pipe.getPos());
        LOGGER.debug("Pipe removed at {}", (Object)pipe.getPos());
        this.setDirty();
        if (pipe.getNetwork() != null) {
            this.splitNetworks(pipe);
        }
    }

    private void splitNetworks(Pipe originPipe) {
        for (Pipe adjacent : this.findAdjacentPipes(originPipe.getPos(), originPipe.getNetworkType())) {
            if (adjacent.getNetwork() == null) {
                throw new RuntimeException("Adjacent pipe has no network");
            }
            if (adjacent.getNetwork() == originPipe.getNetwork()) continue;
            throw new RuntimeException("The origin pipe network is different than the adjacent pipe network");
        }
        Pipe otherPipeInNetwork = this.findFirstAdjacentPipe(originPipe.getPos(), originPipe.getNetworkType());
        if (otherPipeInNetwork == null) {
            this.removeNetwork(originPipe.getNetwork().getId());
            return;
        }
        List<Pipe> adjacentPipes = this.findAdjacentPipes(originPipe.getPos(), originPipe.getNetworkType());
        if (adjacentPipes.size() == 1) {
            originPipe.getNetwork().scanGraph(originPipe.getLevel(), otherPipeInNetwork.getPos());
        } else {
            Network originalNetwork = originPipe.getNetwork();
            this.removeNetwork(originalNetwork.getId());
            for (Pipe adjacentPipe : adjacentPipes) {
                adjacentPipe.leaveNetwork();
            }
            for (Pipe adjacentPipe : adjacentPipes) {
                if (adjacentPipe.getNetwork() != null) continue;
                this.formNetworkAt(adjacentPipe.getLevel(), adjacentPipe.getPos(), adjacentPipe.getNetworkType());
            }
        }
    }

    @Nullable
    private Pipe findFirstAdjacentPipe(BlockPos pos, ResourceLocation networkType) {
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.relative(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            return pipe;
        }
        return null;
    }

    @Nullable
    public Pipe getPipe(BlockPos pos) {
        return this.pipes.get(pos);
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag pipes = tag.getList("pipes", 10);
        for (Tag pipeTag : pipes) {
            CompoundTag pipeTagCompound = (CompoundTag)pipeTag;
            ResourceLocation factoryId = pipeTagCompound.contains("id") ? ResourceLocation.parse((String)pipeTagCompound.getString("id")) : ItemPipe.ID;
            PipeFactory factory = PipeRegistry.INSTANCE.getFactory(factoryId);
            if (factory == null) {
                LOGGER.warn("Pipe {} no longer exists", (Object)factoryId.toString());
                continue;
            }
            Pipe pipe = factory.createFromNbt(this.level, pipeTagCompound);
            this.pipes.put(pipe.getPos(), pipe);
        }
        ListTag nets = tag.getList("networks", 10);
        for (Tag netTag : nets) {
            CompoundTag netTagCompound = (CompoundTag)netTag;
            if (!netTagCompound.contains("type")) {
                LOGGER.warn("Skipping network without type");
                continue;
            }
            ResourceLocation type = ResourceLocation.parse((String)netTagCompound.getString("type"));
            NetworkFactory factory = NetworkRegistry.INSTANCE.getFactory(type);
            if (factory == null) {
                LOGGER.warn("Unknown network type {}", (Object)type.toString());
                continue;
            }
            Network network = factory.create(netTagCompound);
            this.networks.put(network.getId(), network);
        }
        LOGGER.debug("Read {} pipes", (Object)pipes.size());
        LOGGER.debug("Read {} networks", (Object)this.networks.size());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag pipes = new ListTag();
        this.pipes.values().forEach(p -> {
            CompoundTag pipeTag = new CompoundTag();
            pipeTag.putString("id", p.getId().toString());
            pipes.add((Object)p.writeToNbt(pipeTag));
        });
        tag.put("pipes", (Tag)pipes);
        ListTag networks = new ListTag();
        this.networks.values().forEach(n -> {
            CompoundTag networkTag = new CompoundTag();
            networkTag.putString("type", n.getType().toString());
            networks.add((Object)n.writeToNbt(networkTag));
        });
        tag.put("networks", (Tag)networks);
        return tag;
    }
}

