/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.energy;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.energy.EnergyStorage;
import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerResult;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.DestinationType;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyNetwork
extends Network {
    private final EnergyStorage energyStorage;
    private final EnergyPipeType pipeType;

    public EnergyNetwork(BlockPos originPos, String id, EnergyPipeType pipeType) {
        super(originPos, id);
        this.pipeType = pipeType;
        this.energyStorage = new EnergyStorage(0);
        this.energyStorage.setMaxReceive(pipeType.getCapacity());
    }

    @Override
    public NetworkGraphScannerResult scanGraph(Level level, BlockPos pos) {
        NetworkGraphScannerResult result = super.scanGraph(level, pos);
        this.energyStorage.setCapacityAndMaxExtract(result.getFoundPipes().stream().filter(p -> p instanceof EnergyPipe).mapToInt(p -> ((EnergyPipe)p).getType().getCapacity()).sum());
        if (this.energyStorage.getEnergyStored() > this.energyStorage.getMaxEnergyStored()) {
            this.energyStorage.setStored(this.energyStorage.getMaxEnergyStored());
        }
        return result;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void update(Level level) {
        super.update(level);
        List<Destination> destinations = this.graph.getDestinations(DestinationType.ENERGY_STORAGE);
        if (!destinations.isEmpty()) {
            if (this.energyStorage.getEnergyStored() <= 0) {
                return;
            }
            for (Destination destination : destinations) {
                IEnergyStorage handler;
                BlockEntity blockEntity = destination.getConnectedPipe().getLevel().getBlockEntity(destination.getReceiver());
                if (blockEntity == null || (handler = (IEnergyStorage)blockEntity.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, destination.getReceiver(), (Object)destination.getIncomingDirection().getOpposite())) == null || !handler.canReceive()) continue;
                int toOffer = Math.min(this.pipeType.getTransferRate(), this.energyStorage.getEnergyStored());
                if (toOffer <= 0 || (toOffer = this.energyStorage.extractEnergy(toOffer, false)) <= 0) break;
                int accepted = handler.receiveEnergy(toOffer, false);
                int remainder = toOffer - accepted;
                if (remainder <= 0) continue;
                this.energyStorage.receiveEnergy(remainder, false);
            }
        }
    }

    @Override
    public void onMergedWith(Network mainNetwork) {
        ((EnergyNetwork)mainNetwork).energyStorage.receiveEnergy(this.energyStorage.getEnergyStored(), false);
    }

    @Override
    public ResourceLocation getType() {
        return this.pipeType.getNetworkType();
    }

    public EnergyPipeType getPipeType() {
        return this.pipeType;
    }
}

