/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.fluid;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerResult;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.DestinationType;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipe;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidNetwork
extends Network {
    private final FluidTank fluidTank = new FluidTank(1000);
    private final FluidPipeType pipeType;

    public FluidNetwork(BlockPos originPos, String id, FluidPipeType pipeType) {
        super(originPos, id);
        this.pipeType = pipeType;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public NetworkGraphScannerResult scanGraph(Level level, BlockPos pos) {
        NetworkGraphScannerResult result = super.scanGraph(level, pos);
        this.fluidTank.setCapacity(result.getFoundPipes().stream().filter(p -> p instanceof FluidPipe).mapToInt(p -> ((FluidPipe)p).getType().getCapacity()).sum());
        if (this.fluidTank.getFluidAmount() > this.fluidTank.getCapacity()) {
            this.fluidTank.getFluid().setAmount(this.fluidTank.getCapacity());
        }
        return result;
    }

    @Override
    public void update(Level level) {
        super.update(level);
        List<Destination> destinations = this.graph.getDestinations(DestinationType.FLUID_HANDLER);
        if (this.fluidTank.getFluid().isEmpty() || destinations.isEmpty()) {
            return;
        }
        for (Destination destination : destinations) {
            FluidStack toOffer;
            IFluidHandler handler;
            BlockEntity blockEntity = destination.getConnectedPipe().getLevel().getBlockEntity(destination.getReceiver());
            if (blockEntity == null || (handler = (IFluidHandler)blockEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, destination.getReceiver(), (Object)destination.getIncomingDirection().getOpposite())) == null) continue;
            int toOfferAmount = Math.min(this.pipeType.getTransferRate(), this.fluidTank.getFluidAmount());
            if (toOfferAmount <= 0 || (toOffer = this.fluidTank.drain(toOfferAmount, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) break;
            int accepted = handler.fill(toOffer, IFluidHandler.FluidAction.EXECUTE);
            int remainder = toOffer.getAmount() - accepted;
            if (remainder <= 0) continue;
            FluidStack remainderStack = toOffer.copy();
            remainderStack.setAmount(remainder);
            this.fluidTank.fill(remainderStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onMergedWith(Network mainNetwork) {
        ((FluidNetwork)mainNetwork).getFluidTank().fill(this.fluidTank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public ResourceLocation getType() {
        return this.pipeType.getNetworkType();
    }

    public FluidPipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag = super.writeToNbt(tag);
        return tag;
    }
}

