/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.fluid;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.NetworkFactory;
import com.piglinmine.fastpipes.network.fluid.FluidNetwork;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import com.piglinmine.fastpipes.util.StringUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidNetworkFactory
implements NetworkFactory {
    private static final Logger LOGGER = LogManager.getLogger(FluidNetworkFactory.class);
    private final FluidPipeType pipeType;

    public FluidNetworkFactory(FluidPipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public Network create(BlockPos pos) {
        return new FluidNetwork(pos, StringUtil.randomString(new Random(), 8), this.pipeType);
    }

    @Override
    public Network create(CompoundTag tag) {
        FluidNetwork network = new FluidNetwork(BlockPos.of((long)tag.getLong("origin")), tag.getString("id"), this.pipeType);
        LOGGER.debug("Deserialized fluid network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
        return network;
    }
}

