/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.graph;

import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerRequest;
import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerResult;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.DestinationType;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeEnergyStorage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class NetworkGraphScanner {
    private final Set<Pipe> foundPipes = new HashSet<Pipe>();
    private final Set<Pipe> newPipes = new HashSet<Pipe>();
    private final Set<Pipe> removedPipes = new HashSet<Pipe>();
    private final Set<Destination> destinations = new HashSet<Destination>();
    private final Set<Pipe> currentPipes;
    private final ResourceLocation requiredNetworkType;
    private final List<NetworkGraphScannerRequest> allRequests = new ArrayList<NetworkGraphScannerRequest>();
    private final Queue<NetworkGraphScannerRequest> requests = new ArrayDeque<NetworkGraphScannerRequest>();

    public NetworkGraphScanner(Set<Pipe> currentPipes, ResourceLocation requiredNetworkType) {
        this.currentPipes = currentPipes;
        this.removedPipes.addAll(currentPipes);
        this.requiredNetworkType = requiredNetworkType;
    }

    public NetworkGraphScannerResult scanAt(Level level, BlockPos pos) {
        NetworkGraphScannerRequest request;
        this.addRequest(new NetworkGraphScannerRequest(level, pos, null, null));
        while ((request = this.requests.poll()) != null) {
            this.singleScanAt(request);
        }
        return new NetworkGraphScannerResult(this.foundPipes, this.newPipes, this.removedPipes, this.destinations, this.allRequests);
    }

    private void singleScanAt(NetworkGraphScannerRequest request) {
        BlockEntity blockEntity;
        Pipe connectedPipe;
        Pipe pipe = NetworkManager.get(request.getLevel()).getPipe(request.getPos());
        if (pipe != null) {
            if (!this.requiredNetworkType.equals((Object)pipe.getNetworkType())) {
                return;
            }
            if (this.foundPipes.add(pipe)) {
                if (!this.currentPipes.contains(pipe)) {
                    this.newPipes.add(pipe);
                }
                this.removedPipes.remove(pipe);
                request.setSuccessful(true);
                for (Direction dir : Direction.values()) {
                    this.addRequest(new NetworkGraphScannerRequest(request.getLevel(), request.getPos().relative(dir), dir, request));
                }
            }
        } else if (request.getParent() != null && !(connectedPipe = NetworkManager.get(request.getLevel()).getPipe(request.getParent().getPos())).getAttachmentManager().hasAttachment(request.getDirection()) && (blockEntity = request.getLevel().getBlockEntity(request.getPos())) != null) {
            IEnergyStorage energyStorage;
            IFluidHandler fluidHandler;
            IItemHandler itemHandler = (IItemHandler)request.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, request.getPos(), (Object)request.getDirection().getOpposite());
            if (itemHandler != null) {
                this.destinations.add(new Destination(DestinationType.ITEM_HANDLER, request.getPos(), request.getDirection(), connectedPipe));
            }
            if ((fluidHandler = (IFluidHandler)request.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, request.getPos(), (Object)request.getDirection().getOpposite())) != null) {
                this.destinations.add(new Destination(DestinationType.FLUID_HANDLER, request.getPos(), request.getDirection(), connectedPipe));
            }
            if ((energyStorage = (IEnergyStorage)request.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, request.getPos(), (Object)request.getDirection().getOpposite())) != null && !(energyStorage instanceof EnergyPipeEnergyStorage)) {
                this.destinations.add(new Destination(DestinationType.ENERGY_STORAGE, request.getPos(), request.getDirection(), connectedPipe));
            }
        }
    }

    private void addRequest(NetworkGraphScannerRequest request) {
        this.requests.add(request);
        this.allRequests.add(request);
    }
}

