/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.item.routing;

import com.piglinmine.fastpipes.network.item.routing.DestinationPathCache;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.routing.DijkstraAlgorithm;
import com.piglinmine.fastpipes.routing.Graph;
import com.piglinmine.fastpipes.routing.Node;
import com.piglinmine.fastpipes.routing.NodeIndex;
import com.piglinmine.fastpipes.routing.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationPathCacheFactory {
    private static final Logger LOGGER = LogManager.getLogger(DestinationPathCacheFactory.class);
    private final Graph<BlockPos> graph;
    private final NodeIndex<BlockPos> nodeIndex;
    private final List<Destination> destinations;

    public DestinationPathCacheFactory(Graph<BlockPos> graph, NodeIndex<BlockPos> nodeIndex, List<Destination> destinations) {
        this.graph = graph;
        this.nodeIndex = nodeIndex;
        this.destinations = destinations;
    }

    public DestinationPathCache create() {
        DestinationPathCache cache = new DestinationPathCache();
        for (Node<BlockPos> node : this.graph.getNodes()) {
            DijkstraAlgorithm<BlockPos> dijkstra = new DijkstraAlgorithm<BlockPos>(this.graph);
            dijkstra.execute(node);
            for (Destination destination : this.destinations) {
                if (destination.getConnectedPipe().getPos().equals((Object)node.getId())) {
                    ArrayList nodes = new ArrayList();
                    nodes.add(node);
                    cache.addPath(node.getId(), destination, new Path<BlockPos>(nodes));
                    continue;
                }
                Pipe connectedPipe = destination.getConnectedPipe();
                Node<BlockPos> connectedPipeNode = this.nodeIndex.getNode(connectedPipe.getPos());
                if (connectedPipeNode == null) {
                    LOGGER.error("Connected pipe has no node! At " + String.valueOf(connectedPipe.getPos()));
                    continue;
                }
                LinkedList path = dijkstra.getPath(connectedPipeNode);
                if (path != null) {
                    cache.addPath(node.getId(), destination, new Path<BlockPos>(path));
                    LOGGER.debug("Computed path from " + String.valueOf(node.getId()) + " to " + String.valueOf(connectedPipeNode.getId()) + " -> " + path.size() + " nodes");
                    continue;
                }
                LOGGER.error("Could not find path from " + String.valueOf(node.getId()) + " to " + String.valueOf(connectedPipeNode.getId()));
            }
        }
        return cache;
    }
}

