/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.item.routing;

import com.piglinmine.fastpipes.network.graph.NetworkGraphScannerRequest;
import com.piglinmine.fastpipes.routing.Edge;
import com.piglinmine.fastpipes.routing.NodeIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EdgeFactory {
    private static final Logger LOGGER = LogManager.getLogger(EdgeFactory.class);
    private final NodeIndex<BlockPos> nodeIndex;
    private final List<NetworkGraphScannerRequest> allRequests;

    public EdgeFactory(NodeIndex<BlockPos> nodeIndex, List<NetworkGraphScannerRequest> allRequests) {
        this.nodeIndex = nodeIndex;
        this.allRequests = allRequests;
    }

    public List<Edge<BlockPos>> create() {
        ArrayList<Edge<BlockPos>> edges = new ArrayList<Edge<BlockPos>>();
        for (NetworkGraphScannerRequest request : this.allRequests) {
            if (!request.isSuccessful() || request.getParent() == null) continue;
            BlockPos origin = request.getParent().getPos();
            BlockPos destination = request.getPos();
            LOGGER.debug("Connecting " + String.valueOf(origin) + " to " + String.valueOf(destination));
            edges.add(new Edge<BlockPos>("Edge", this.nodeIndex.getNode(origin), this.nodeIndex.getNode(destination), 1));
            edges.add(new Edge<BlockPos>("Edge", this.nodeIndex.getNode(destination), this.nodeIndex.getNode(origin), 1));
        }
        return edges;
    }
}

