/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.message;

import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RedstoneMode;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChangeRedstoneModeMessage(BlockPos pos, Direction direction, int mode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChangeRedstoneModeMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"change_redstone_mode"));
    public static final StreamCodec<ByteBuf, ChangeRedstoneModeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ChangeRedstoneModeMessage::pos, (StreamCodec)Direction.STREAM_CODEC, ChangeRedstoneModeMessage::direction, (StreamCodec)ByteBufCodecs.VAR_INT, ChangeRedstoneModeMessage::mode, ChangeRedstoneModeMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(ChangeRedstoneModeMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Attachment attachment;
            if (context.player() == null || context.player().level() == null) {
                return;
            }
            BlockEntity blockEntity = context.player().level().getBlockEntity(message.pos());
            if (blockEntity instanceof PipeBlockEntity && (attachment = ((PipeBlockEntity)blockEntity).getAttachmentManager().getAttachment(message.direction())) instanceof ExtractorAttachment) {
                RedstoneMode redstoneMode = RedstoneMode.get((byte)message.mode());
                ((ExtractorAttachment)attachment).setRedstoneMode(redstoneMode);
                NetworkManager.get(blockEntity.getLevel()).setDirty();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Failed to handle ChangeRedstoneModeMessage: " + e.getMessage())));
            return null;
        });
    }
}

