/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.message;

import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChangeStackSizeMessage(BlockPos pos, Direction direction, int stackSize) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChangeStackSizeMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"change_stack_size"));
    public static final StreamCodec<ByteBuf, ChangeStackSizeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ChangeStackSizeMessage::pos, (StreamCodec)Direction.STREAM_CODEC, ChangeStackSizeMessage::direction, (StreamCodec)ByteBufCodecs.VAR_INT, ChangeStackSizeMessage::stackSize, ChangeStackSizeMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(ChangeStackSizeMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Attachment attachment;
            if (context.player() == null || context.player().level() == null) {
                return;
            }
            BlockEntity blockEntity = context.player().level().getBlockEntity(message.pos());
            if (blockEntity instanceof PipeBlockEntity && (attachment = ((PipeBlockEntity)blockEntity).getAttachmentManager().getAttachment(message.direction())) instanceof ExtractorAttachment) {
                ((ExtractorAttachment)attachment).setStackSize(message.stackSize());
                NetworkManager.get(blockEntity.getLevel()).setDirty();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Failed to handle ChangeStackSizeMessage: " + e.getMessage())));
            return null;
        });
    }
}

