/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.message;

import com.piglinmine.fastpipes.blockentity.ItemPipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransportProps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ItemTransportMessage(BlockPos pos, List<ItemTransportProps> props) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemTransportMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"item_transport"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemTransportMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ItemTransportMessage::pos, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, ItemTransportProps.STREAM_CODEC), ItemTransportMessage::props, ItemTransportMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(ItemTransportMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(message.pos());
            if (blockEntity instanceof ItemPipeBlockEntity) {
                ItemPipeBlockEntity itemPipeBlockEntity = (ItemPipeBlockEntity)blockEntity;
                itemPipeBlockEntity.setProps(message.props());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Failed to handle ItemTransportMessage: " + e.getMessage())));
            return null;
        });
    }
}

