/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.ServerAttachmentManager;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Pipe {
    protected final Level level;
    protected final BlockPos pos;
    protected final ServerAttachmentManager attachmentManager = new ServerAttachmentManager(this);
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected Network network;

    public Pipe(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public void update() {
        for (Attachment attachment : this.attachmentManager.getAttachments()) {
            attachment.update();
        }
    }

    public ServerAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void joinNetwork(Network network) {
        this.network = network;
        this.logger.debug(String.valueOf(this.pos) + " joined network " + network.getId());
        this.sendBlockUpdate();
    }

    public void leaveNetwork() {
        this.logger.debug(String.valueOf(this.pos) + " left network " + this.network.getId());
        this.network = null;
        this.sendBlockUpdate();
    }

    public void sendBlockUpdate() {
        BlockState state = this.level.getBlockState(this.pos);
        this.level.sendBlockUpdated(this.pos, state, state, 3);
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putLong("pos", this.pos.asLong());
        this.attachmentManager.writeToNbt(tag);
        return tag;
    }

    public void readFromNbt(CompoundTag tag) {
        this.attachmentManager.readFromNbt(tag);
    }

    public abstract ResourceLocation getId();

    public abstract ResourceLocation getNetworkType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipe pipe = (Pipe)o;
        return this.level.equals(pipe.level) && this.pos.equals((Object)pipe.pos);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.pos);
    }
}

