/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment;

import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClientAttachmentManager
implements AttachmentManager {
    private final ResourceLocation[] attachmentState = new ResourceLocation[Direction.values().length];
    private final ItemStack[] pickBlocks = new ItemStack[Direction.values().length];

    public ClientAttachmentManager() {
        for (int i = 0; i < this.pickBlocks.length; ++i) {
            this.pickBlocks[i] = ItemStack.EMPTY;
        }
    }

    @Override
    public ResourceLocation[] getState() {
        return this.attachmentState;
    }

    @Override
    public boolean hasAttachment(Direction dir) {
        return this.attachmentState[dir.ordinal()] != null;
    }

    @Override
    public void openAttachmentContainer(Direction dir, ServerPlayer player) {
        throw new RuntimeException("Shouldn't be called on the client");
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(Direction dir) {
        return this.pickBlocks[dir.ordinal()];
    }

    @Override
    @Nullable
    public Attachment getAttachment(Direction dir) {
        return null;
    }

    @Override
    public void writeUpdate(CompoundTag tag) {
        throw new RuntimeException("Shouldn't be called on the client");
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag) {
        if (tag == null) {
            for (int i = 0; i < this.attachmentState.length; ++i) {
                this.attachmentState[i] = null;
                this.pickBlocks[i] = ItemStack.EMPTY;
            }
            return;
        }
        for (Direction dir : Direction.values()) {
            String attachmentKey = "attch_" + dir.ordinal();
            String pickBlockKey = "pb_" + dir.ordinal();
            if (tag.contains(attachmentKey)) {
                this.attachmentState[dir.ordinal()] = ResourceLocation.parse((String)tag.getString(attachmentKey));
                if (!tag.contains(pickBlockKey)) continue;
                this.pickBlocks[dir.ordinal()] = ItemStack.EMPTY;
                continue;
            }
            this.attachmentState[dir.ordinal()] = null;
            this.pickBlocks[dir.ordinal()] = ItemStack.EMPTY;
        }
    }
}

