/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment;

import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentManager;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerAttachmentManager
implements AttachmentManager {
    private static final Logger LOGGER = LogManager.getLogger(ServerAttachmentManager.class);
    private final Map<Direction, Attachment> attachments = new HashMap<Direction, Attachment>();
    private final ResourceLocation[] attachmentState = new ResourceLocation[Direction.values().length];
    private final Pipe pipe;

    public ServerAttachmentManager(Pipe pipe) {
        this.pipe = pipe;
    }

    @Override
    public boolean hasAttachment(Direction dir) {
        return this.attachments.containsKey(dir);
    }

    @Override
    public void openAttachmentContainer(Direction dir, ServerPlayer player) {
        if (this.hasAttachment(dir)) {
            this.getAttachment(dir).openContainer(player);
        }
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(Direction dir) {
        throw new RuntimeException("Shouldn't be called on the server");
    }

    public void removeAttachmentAndScanGraph(Direction dir) {
        this.attachments.remove(dir);
        this.attachmentState[dir.ordinal()] = null;
        this.pipe.getNetwork().scanGraph(this.pipe.getLevel(), this.pipe.getPos());
    }

    public void setAttachmentAndScanGraph(Direction dir, Attachment attachment) {
        this.setAttachment(dir, attachment);
        this.pipe.getNetwork().scanGraph(this.pipe.getLevel(), this.pipe.getPos());
    }

    private void setAttachment(Direction dir, Attachment attachment) {
        this.attachments.put(dir, attachment);
        this.attachmentState[dir.ordinal()] = attachment.getId();
    }

    @Override
    @Nullable
    public Attachment getAttachment(Direction dir) {
        return this.attachments.get(dir);
    }

    public Collection<Attachment> getAttachments() {
        return this.attachments.values();
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        ListTag attch = new ListTag();
        this.getAttachments().forEach(a -> {
            CompoundTag attchTag = new CompoundTag();
            attchTag.putString("typ", a.getId().toString());
            attch.add((Object)a.writeToNbt(attchTag));
        });
        tag.put("attch", (Tag)attch);
        return tag;
    }

    public void readFromNbt(CompoundTag tag) {
        ListTag attch = tag.getList("attch", 10);
        for (Tag item : attch) {
            CompoundTag attchTag = (CompoundTag)item;
            AttachmentFactory factory = AttachmentRegistry.INSTANCE.getFactory(ResourceLocation.parse((String)attchTag.getString("typ")));
            if (factory != null) {
                Attachment attachment = factory.createFromNbt(this.pipe, attchTag);
                this.setAttachment(attachment.getDirection(), attachment);
                continue;
            }
            LOGGER.warn("Attachment {} no longer exists", (Object)attchTag.getString("typ"));
        }
    }

    @Override
    public ResourceLocation[] getState() {
        return this.attachmentState;
    }

    @Override
    public void writeUpdate(CompoundTag tag) {
        for (Direction dir : Direction.values()) {
            if (!this.hasAttachment(dir)) continue;
            tag.putString("attch_" + dir.ordinal(), this.getAttachment(dir).getId().toString());
            tag.put("pb_" + dir.ordinal(), this.getAttachment(dir).getDrop().saveOptional((HolderLookup.Provider)this.pipe.getLevel().registryAccess()));
        }
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag) {
        throw new RuntimeException("Client-side only");
    }
}

