/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment.extractor;

import com.piglinmine.fastpipes.inventory.fluid.FluidInventory;
import com.piglinmine.fastpipes.menu.ExtractorAttachmentMenuProvider;
import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.fluid.FluidNetwork;
import com.piglinmine.fastpipes.network.item.ItemNetwork;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ItemDestinationFinder;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RoutingMode;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipe;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransport;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemBounceBackTransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemInsertTransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallback;
import com.piglinmine.fastpipes.routing.Path;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractorAttachment
extends Attachment {
    public static final int MAX_FILTER_SLOTS = 15;
    private static final Logger LOGGER = LogManager.getLogger(ExtractorAttachment.class);
    private final ExtractorAttachmentType type;
    private final ItemStackHandler itemFilter;
    private final FluidInventory fluidFilter;
    private final ItemDestinationFinder itemDestinationFinder = new ItemDestinationFinder(this);
    private int ticks;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    private BlacklistWhitelist blacklistWhitelist = BlacklistWhitelist.BLACKLIST;
    private RoutingMode routingMode = RoutingMode.NEAREST;
    private int stackSize;
    private boolean exactMode = true;

    public ExtractorAttachment(Pipe pipe, Direction direction, ExtractorAttachmentType type) {
        super(pipe, direction);
        this.type = type;
        this.stackSize = type.getItemsToExtract();
        this.itemFilter = ExtractorAttachment.createItemFilterInventory(this);
        this.fluidFilter = ExtractorAttachment.createFluidFilterInventory(this);
    }

    public static ItemStackHandler createItemFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getLevel()).setDirty();
                }
            }
        };
    }

    public static FluidInventory createFluidFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new FluidInventory(15){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getLevel()).setDirty();
                }
            }
        };
    }

    public boolean isFluidMode() {
        return this.pipe.getNetwork() instanceof FluidNetwork;
    }

    @Override
    public void update() {
        IFluidHandler fluidHandler;
        Network network = this.pipe.getNetwork();
        int tickInterval = 0;
        if (network instanceof ItemNetwork) {
            tickInterval = this.type.getItemTickInterval();
        } else if (network instanceof FluidNetwork) {
            tickInterval = this.type.getFluidTickInterval();
        }
        if (tickInterval != 0 && this.ticks++ % tickInterval != 0) {
            return;
        }
        if (!this.redstoneMode.isEnabled(this.pipe.getLevel(), this.pipe.getPos())) {
            return;
        }
        BlockPos destinationPos = this.pipe.getPos().relative(this.getDirection());
        BlockEntity blockEntity = this.pipe.getLevel().getBlockEntity(destinationPos);
        if (blockEntity == null) {
            return;
        }
        if (network instanceof ItemNetwork) {
            IItemHandler itemHandler = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, destinationPos, (Object)this.getDirection().getOpposite());
            if (itemHandler != null) {
                this.update((ItemNetwork)network, destinationPos, itemHandler);
            }
        } else if (network instanceof FluidNetwork && (fluidHandler = (IFluidHandler)blockEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, destinationPos, (Object)this.getDirection().getOpposite())) != null) {
            this.update((FluidNetwork)network, fluidHandler);
        }
    }

    private void update(ItemNetwork network, BlockPos sourcePos, IItemHandler source) {
        if (this.stackSize == 0) {
            return;
        }
        Pair<Destination, Integer> destinationAndSourceSlot = this.findDestinationAndSourceSlot(sourcePos, source);
        if (destinationAndSourceSlot == null) {
            return;
        }
        Destination destination = (Destination)destinationAndSourceSlot.getLeft();
        Path<BlockPos> path = network.getDestinationPathCache().getPath(this.pipe.getPos(), destination);
        if (path == null) {
            LOGGER.error("No path found from " + String.valueOf(this.pipe.getPos()) + " to " + String.valueOf(destination));
            return;
        }
        ItemStack extracted = source.extractItem(((Integer)destinationAndSourceSlot.getRight()).intValue(), this.stackSize, false);
        if (extracted.isEmpty()) {
            return;
        }
        BlockPos fromPos = this.pipe.getPos().relative(this.getDirection());
        ((ItemPipe)this.pipe).addTransport(new ItemTransport(extracted.copy(), fromPos, destination.getReceiver(), path.toQueue(), new ItemInsertTransportCallback(destination.getReceiver(), destination.getIncomingDirection(), extracted), new ItemBounceBackTransportCallback(destination.getReceiver(), sourcePos, extracted), new ItemPipeGoneTransportCallback(extracted)));
    }

    private Pair<Destination, Integer> findDestinationAndSourceSlot(BlockPos sourcePos, IItemHandler source) {
        if (source.getSlots() <= 0) {
            return null;
        }
        int startIndex = 0;
        do {
            ItemStack slot;
            if ((slot = source.getStackInSlot(startIndex)).isEmpty() || !this.acceptsItem(slot)) {
                ++startIndex;
                continue;
            }
            ItemStack extracted = source.extractItem(startIndex, this.stackSize, true);
            if (extracted.isEmpty()) {
                ++startIndex;
                continue;
            }
            Destination destination = this.itemDestinationFinder.find(this.routingMode, sourcePos, extracted);
            if (destination == null) {
                ++startIndex;
                continue;
            }
            return Pair.of((Object)destination, (Object)startIndex);
        } while (startIndex < source.getSlots());
        return null;
    }

    private void update(FluidNetwork network, IFluidHandler source) {
        FluidStack drained = source.drain(this.type.getFluidsToExtract(), IFluidHandler.FluidAction.SIMULATE);
        if (drained.isEmpty()) {
            return;
        }
        if (!this.acceptsFluid(drained)) {
            return;
        }
        int filled = network.getFluidTank().fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return;
        }
        int toDrain = Math.min(this.type.getFluidsToExtract(), filled);
        drained = source.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        network.getFluidTank().fill(drained, IFluidHandler.FluidAction.EXECUTE);
        NetworkManager.get(this.pipe.getLevel()).setDirty();
    }

    private boolean acceptsItem(ItemStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.is(stack.getItem());
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.isSameItemSameComponents((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.is(stack.getItem());
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.isSameItemSameComponents((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean acceptsFluid(FluidStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl2 = equals = equals && FluidStack.isSameFluidSameComponents((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl3 = equals = equals && FluidStack.isSameFluidSameComponents((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void openContainer(ServerPlayer player) {
        super.openContainer(player);
        ExtractorAttachmentMenuProvider.open(this.pipe, this, player);
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ItemStack getDrop() {
        return new ItemStack((ItemLike)this.type.getItem());
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putByte("rm", (byte)this.redstoneMode.ordinal());
        tag.put("itemfilter", (Tag)this.itemFilter.serializeNBT((HolderLookup.Provider)this.pipe.getLevel().registryAccess()));
        tag.putByte("bw", (byte)this.blacklistWhitelist.ordinal());
        tag.putInt("rr", this.itemDestinationFinder.getRoundRobinIndex());
        tag.putByte("routingm", (byte)this.routingMode.ordinal());
        tag.putInt("stacksi", this.stackSize);
        tag.putBoolean("exa", this.exactMode);
        tag.put("fluidfilter", (Tag)this.fluidFilter.writeToNbt((HolderLookup.Provider)this.pipe.getLevel().registryAccess()));
        return super.writeToNbt(tag);
    }

    public ExtractorAttachmentType getType() {
        return this.type;
    }

    public ItemStackHandler getItemFilter() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilter() {
        return this.fluidFilter;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        if (!this.type.getCanSetRedstoneMode()) {
            return;
        }
        this.redstoneMode = redstoneMode;
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        if (!this.type.getCanSetWhitelistBlacklist()) {
            return;
        }
        this.blacklistWhitelist = blacklistWhitelist;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public void setRoutingMode(RoutingMode routingMode) {
        if (!this.type.getCanSetRoutingMode()) {
            return;
        }
        this.routingMode = routingMode;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        if (stackSize < 0) {
            stackSize = 0;
        }
        if (stackSize > this.type.getItemsToExtract()) {
            stackSize = this.type.getItemsToExtract();
        }
        this.stackSize = stackSize;
    }

    public void setRoundRobinIndex(int roundRobinIndex) {
        this.itemDestinationFinder.setRoundRobinIndex(roundRobinIndex);
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public void setExactMode(boolean exactMode) {
        if (!this.type.getCanSetExactMode()) {
            return;
        }
        this.exactMode = exactMode;
    }
}

