/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment.extractor;

import com.piglinmine.fastpipes.block.FluidPipeBlock;
import com.piglinmine.fastpipes.block.ItemPipeBlock;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RoutingMode;
import com.piglinmine.fastpipes.util.DirectionUtil;
import com.piglinmine.fastpipes.util.StringUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ExtractorAttachmentFactory
implements AttachmentFactory {
    private final ExtractorAttachmentType type;

    public ExtractorAttachmentFactory(ExtractorAttachmentType type) {
        this.type = type;
    }

    @Override
    public Attachment createFromNbt(Pipe pipe, CompoundTag tag) {
        Direction dir = DirectionUtil.safeGet((byte)tag.getInt("dir"));
        ExtractorAttachment attachment = new ExtractorAttachment(pipe, dir, this.type);
        if (tag.contains("itemfilter")) {
            attachment.getItemFilter().deserializeNBT((HolderLookup.Provider)pipe.getLevel().registryAccess(), tag.getCompound("itemfilter"));
        }
        if (tag.contains("rm")) {
            attachment.setRedstoneMode(RedstoneMode.get(tag.getByte("rm")));
        }
        if (tag.contains("bw")) {
            attachment.setBlacklistWhitelist(BlacklistWhitelist.get(tag.getByte("bw")));
        }
        if (tag.contains("rr")) {
            attachment.setRoundRobinIndex(tag.getInt("rr"));
        }
        if (tag.contains("routingm")) {
            attachment.setRoutingMode(RoutingMode.get(tag.getByte("routingm")));
        }
        if (tag.contains("stacksi")) {
            attachment.setStackSize(tag.getInt("stacksi"));
        }
        if (tag.contains("exa")) {
            attachment.setExactMode(tag.getBoolean("exa"));
        }
        if (tag.contains("fluidfilter")) {
            attachment.getFluidFilter().readFromNbt(tag.getCompound("fluidfilter"), (HolderLookup.Provider)pipe.getLevel().registryAccess());
        }
        return attachment;
    }

    @Override
    public Attachment create(Pipe pipe, Direction dir) {
        return new ExtractorAttachment(pipe, dir, this.type);
    }

    @Override
    public ResourceLocation getItemId() {
        return this.type.getItemId();
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ResourceLocation getModelLocation() {
        return this.type.getModelLocation();
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"misc.fastpipes.tier", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + this.type.getTier()))}).withStyle(ChatFormatting.YELLOW));
        MutableComponent itemsToExtract = Component.literal((String)(StringUtil.formatNumber(this.type.getItemsToExtract()) + " ")).append((Component)Component.translatable((String)("misc.fastpipes.item" + (this.type.getItemsToExtract() == 1 ? "" : "s")))).withStyle(ChatFormatting.WHITE);
        float itemSecondsInterval = (float)this.type.getItemTickInterval() / 20.0f;
        MutableComponent itemTickInterval = Component.literal((String)(StringUtil.formatNumber(itemSecondsInterval) + " ")).append((Component)Component.translatable((String)("misc.fastpipes.second" + (itemSecondsInterval == 1.0f ? "" : "s")))).withStyle(ChatFormatting.WHITE);
        tooltip.add((Component)Component.translatable((String)"tooltip.fastpipes.extractor_attachment.item_extraction_rate", (Object[])new Object[]{itemsToExtract, itemTickInterval}).withStyle(ChatFormatting.GRAY));
        MutableComponent fluidsToExtract = Component.literal((String)(StringUtil.formatNumber(this.type.getFluidsToExtract()) + " mB")).withStyle(ChatFormatting.WHITE);
        float fluidSecondsInterval = (float)this.type.getFluidTickInterval() / 20.0f;
        MutableComponent fluidTickInterval = Component.literal((String)(StringUtil.formatNumber(fluidSecondsInterval) + " ")).append((Component)Component.translatable((String)("misc.fastpipes.second" + (fluidSecondsInterval == 1.0f ? "" : "s")))).withStyle(ChatFormatting.WHITE);
        tooltip.add((Component)Component.translatable((String)"tooltip.fastpipes.extractor_attachment.fluid_extraction_rate", (Object[])new Object[]{fluidsToExtract, fluidTickInterval}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.fastpipes.extractor_attachment.filter_slots", (Object[])new Object[]{Component.literal((String)("" + this.type.getFilterSlots())).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY));
        this.addAbilityToInformation(tooltip, this.type.getCanSetRedstoneMode(), "misc.fastpipes.redstone_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetWhitelistBlacklist(), "misc.fastpipes.mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetRoutingMode(), "misc.fastpipes.routing_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetExactMode(), "misc.fastpipes.exact_mode");
    }

    private void addAbilityToInformation(List<Component> tooltip, boolean possible, String key) {
        tooltip.add((Component)Component.literal((String)(possible ? "\u2713 " : "\u274c ")).append((Component)Component.translatable((String)key)).withStyle(possible ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    @Override
    public boolean canPlaceOnPipe(Block pipe) {
        return pipe instanceof ItemPipeBlock || pipe instanceof FluidPipeBlock;
    }
}

