/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment.extractor;

import com.piglinmine.fastpipes.FPipesItems;
import com.piglinmine.fastpipes.FastPipes;
import com.piglinmine.fastpipes.config.ServerConfig;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public enum ExtractorAttachmentType {
    BASIC(1),
    IMPROVED(2),
    ADVANCED(3),
    ELITE(4),
    ULTIMATE(5);

    private final int tier;

    private ExtractorAttachmentType(int tier) {
        this.tier = tier;
    }

    public static ExtractorAttachmentType get(byte b) {
        ExtractorAttachmentType[] v = ExtractorAttachmentType.values();
        if (b < 0 || b >= v.length) {
            return BASIC;
        }
        return v[b];
    }

    public int getTier() {
        return this.tier;
    }

    public ExtractorAttachmentFactory getFactory() {
        return new ExtractorAttachmentFactory(this);
    }

    int getItemTickInterval() {
        return this.getConfig().getItemTickInterval();
    }

    int getFluidTickInterval() {
        return this.getConfig().getFluidTickInterval();
    }

    public int getItemsToExtract() {
        return this.getConfig().getItemsToExtract();
    }

    int getFluidsToExtract() {
        return this.getConfig().getFluidsToExtract();
    }

    public int getFilterSlots() {
        return this.getConfig().getFilterSlots();
    }

    public boolean getCanSetRedstoneMode() {
        return this.getConfig().getCanSetRedstoneMode();
    }

    public boolean getCanSetWhitelistBlacklist() {
        return this.getConfig().getCanSetWhitelistBlacklist();
    }

    public boolean getCanSetRoutingMode() {
        return this.getConfig().getCanSetRoutingMode();
    }

    public boolean getCanSetExactMode() {
        return this.getConfig().getCanSetExactMode();
    }

    private ServerConfig.ExtractorAttachment getConfig() {
        switch (this.ordinal()) {
            case 0: {
                return FastPipes.SERVER_CONFIG.getBasicExtractorAttachment();
            }
            case 1: {
                return FastPipes.SERVER_CONFIG.getImprovedExtractorAttachment();
            }
            case 2: {
                return FastPipes.SERVER_CONFIG.getAdvancedExtractorAttachment();
            }
            case 3: {
                return FastPipes.SERVER_CONFIG.getEliteExtractorAttachment();
            }
            case 4: {
                return FastPipes.SERVER_CONFIG.getUltimateExtractorAttachment();
            }
        }
        throw new RuntimeException("?");
    }

    public ResourceLocation getId() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"basic_extractor");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"improved_extractor");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"advanced_extractor");
            }
            case 3: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"elite_extractor");
            }
            case 4: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"ultimate_extractor");
            }
        }
        throw new RuntimeException("?");
    }

    ResourceLocation getItemId() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"basic_extractor_attachment");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"improved_extractor_attachment");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"advanced_extractor_attachment");
            }
            case 3: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"elite_extractor_attachment");
            }
            case 4: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"ultimate_extractor_attachment");
            }
        }
        throw new RuntimeException("?");
    }

    Item getItem() {
        switch (this.ordinal()) {
            case 0: {
                return (Item)FPipesItems.BASIC_EXTRACTOR_ATTACHMENT.get();
            }
            case 1: {
                return (Item)FPipesItems.IMPROVED_EXTRACTOR_ATTACHMENT.get();
            }
            case 2: {
                return (Item)FPipesItems.ADVANCED_EXTRACTOR_ATTACHMENT.get();
            }
            case 3: {
                return (Item)FPipesItems.ELITE_EXTRACTOR_ATTACHMENT.get();
            }
            case 4: {
                return (Item)FPipesItems.ULTIMATE_EXTRACTOR_ATTACHMENT.get();
            }
        }
        throw new RuntimeException("?");
    }

    ResourceLocation getModelLocation() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/extractor/basic");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/extractor/improved");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/extractor/advanced");
            }
            case 3: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/extractor/elite");
            }
            case 4: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/extractor/ultimate");
            }
        }
        throw new RuntimeException("?");
    }
}

