/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.attachment.extractor;

import com.piglinmine.fastpipes.network.item.ItemNetwork;
import com.piglinmine.fastpipes.network.pipe.Destination;
import com.piglinmine.fastpipes.network.pipe.DestinationType;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RoutingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemDestinationFinder {
    private final Attachment attachment;
    private int roundRobinIndex;

    public ItemDestinationFinder(Attachment attachment) {
        this.attachment = attachment;
    }

    public Destination find(RoutingMode routingMode, BlockPos sourcePos, ItemStack extracted) {
        ItemNetwork network = (ItemNetwork)this.attachment.getPipe().getNetwork();
        switch (routingMode) {
            case NEAREST: {
                return network.getDestinationPathCache().findNearestDestination(this.attachment.getPipe().getPos(), d -> this.isDestinationApplicable(sourcePos, extracted, (Destination)d));
            }
            case FURTHEST: {
                return network.getDestinationPathCache().findFurthestDestination(this.attachment.getPipe().getPos(), d -> this.isDestinationApplicable(sourcePos, extracted, (Destination)d));
            }
            case RANDOM: {
                ArrayList<Destination> destinations = new ArrayList<Destination>(network.getDestinations(DestinationType.ITEM_HANDLER));
                while (!destinations.isEmpty()) {
                    int randomIndex = this.attachment.getPipe().getLevel().getRandom().nextInt(destinations.size());
                    Destination randomDestination = (Destination)destinations.get(randomIndex);
                    if (this.isDestinationApplicable(sourcePos, extracted, randomDestination)) {
                        return randomDestination;
                    }
                    destinations.remove(randomIndex);
                }
                return null;
            }
            case ROUND_ROBIN: {
                List<Destination> destinations = network.getDestinations(DestinationType.ITEM_HANDLER);
                if (destinations.isEmpty()) {
                    return null;
                }
                if (this.roundRobinIndex >= destinations.size()) {
                    this.roundRobinIndex = 0;
                }
                do {
                    Destination dest;
                    if (this.isDestinationApplicable(sourcePos, extracted, dest = destinations.get(this.roundRobinIndex))) {
                        ++this.roundRobinIndex;
                        return dest;
                    }
                    ++this.roundRobinIndex;
                } while (this.roundRobinIndex < destinations.size());
                return null;
            }
        }
        throw new RuntimeException("?");
    }

    private boolean isDestinationApplicable(BlockPos sourcePos, ItemStack extracted, Destination destination) {
        BlockEntity blockEntity = destination.getConnectedPipe().getLevel().getBlockEntity(destination.getReceiver());
        if (blockEntity == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, destination.getReceiver(), (Object)destination.getIncomingDirection().getOpposite());
        if (handler == null) {
            return false;
        }
        if (destination.getReceiver().equals((Object)sourcePos) && destination.getIncomingDirection() == this.attachment.getDirection()) {
            return false;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)true).isEmpty();
    }

    public int getRoundRobinIndex() {
        return this.roundRobinIndex;
    }

    public void setRoundRobinIndex(int roundRobinIndex) {
        this.roundRobinIndex = roundRobinIndex;
    }
}

