/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.energy;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.energy.EnergyNetwork;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import com.piglinmine.fastpipes.network.pipe.energy.ServerEnergyPipeEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class EnergyPipe
extends Pipe {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"energy");
    private final EnergyPipeType type;
    @Nullable
    private ServerEnergyPipeEnergyStorage energyStorage;

    public EnergyPipe(Level level, BlockPos pos, EnergyPipeType type) {
        super(level, pos);
        this.type = type;
    }

    @Override
    public void joinNetwork(Network network) {
        super.joinNetwork(network);
        this.energyStorage = new ServerEnergyPipeEnergyStorage((EnergyNetwork)network);
    }

    @Override
    public void leaveNetwork() {
        super.leaveNetwork();
        this.energyStorage = null;
    }

    @Nullable
    public ServerEnergyPipeEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public EnergyPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag = super.writeToNbt(tag);
        tag.putInt("type", this.type.ordinal());
        return tag;
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return this.type.getNetworkType();
    }
}

