/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.energy;

import net.minecraft.resources.ResourceLocation;

public enum EnergyPipeType {
    BASIC(0, 1000, 100),
    IMPROVED(1, 2000, 200),
    ADVANCED(2, 4000, 400),
    ELITE(3, 8000, 800),
    ULTIMATE(4, 16000, 1600);

    private final int tier;
    private final int capacity;
    private final int transferRate;

    private EnergyPipeType(int tier, int capacity, int transferRate) {
        this.tier = tier;
        this.capacity = capacity;
        this.transferRate = transferRate;
    }

    public static EnergyPipeType get(int ordinal) {
        EnergyPipeType[] values = EnergyPipeType.values();
        if (ordinal < 0 || ordinal >= values.length) {
            return BASIC;
        }
        return values[ordinal];
    }

    public int getTier() {
        return this.tier;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public ResourceLocation getId() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"basic_energy_pipe");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"improved_energy_pipe");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"advanced_energy_pipe");
            }
            case 3: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"elite_energy_pipe");
            }
            case 4: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"ultimate_energy_pipe");
            }
        }
        throw new RuntimeException("Unknown EnergyPipeType: " + String.valueOf((Object)this));
    }

    public ResourceLocation getNetworkType() {
        return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("energy_" + this.name().toLowerCase()));
    }
}

