/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.fluid;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.fluid.FluidNetwork;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FluidPipe
extends Pipe {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"fluid");
    private final FluidPipeType type;
    private float lastFullness = 0.0f;

    public FluidPipe(Level level, BlockPos pos, FluidPipeType type) {
        super(level, pos);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        float f = this.getFullness();
        if ((double)Math.abs(this.lastFullness - f) >= 0.1) {
            this.lastFullness = f;
            this.sendFluidPipeUpdate();
        }
    }

    public void sendFluidPipeUpdate() {
    }

    public float getFullness() {
        Network network = this.network;
        if (network instanceof FluidNetwork) {
            FluidNetwork fluidNetwork = (FluidNetwork)network;
            int cap = fluidNetwork.getFluidTank().getCapacity();
            int stored = fluidNetwork.getFluidTank().getFluidAmount();
            return (float)Math.round((float)stored / (float)cap * 10.0f) / 10.0f;
        }
        return 0.0f;
    }

    public FluidPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag = super.writeToNbt(tag);
        tag.putInt("type", this.type.ordinal());
        return tag;
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return this.type.getNetworkType();
    }
}

