/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.fluid;

import net.minecraft.resources.ResourceLocation;

public enum FluidPipeType {
    BASIC(0, 1000),
    IMPROVED(1, 2000),
    ADVANCED(2, 4000),
    ELITE(3, 8000),
    ULTIMATE(4, 16000);

    private final int tier;
    private final int capacity;

    private FluidPipeType(int tier, int capacity) {
        this.tier = tier;
        this.capacity = capacity;
    }

    public static FluidPipeType get(int ordinal) {
        FluidPipeType[] values = FluidPipeType.values();
        if (ordinal < 0 || ordinal >= values.length) {
            return BASIC;
        }
        return values[ordinal];
    }

    public int getTier() {
        return this.tier;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getTransferRate() {
        switch (this.ordinal()) {
            case 0: {
                return 50;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 200;
            }
            case 3: {
                return 400;
            }
            case 4: {
                return 800;
            }
        }
        throw new RuntimeException("Unknown FluidPipeType: " + String.valueOf((Object)this));
    }

    public ResourceLocation getId() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"basic_fluid_pipe");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"improved_fluid_pipe");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"advanced_fluid_pipe");
            }
            case 3: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"elite_fluid_pipe");
            }
            case 4: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"ultimate_fluid_pipe");
            }
        }
        throw new RuntimeException("Unknown FluidPipeType: " + String.valueOf((Object)this));
    }

    public ResourceLocation getNetworkType() {
        return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("fluid_" + this.name().toLowerCase()));
    }
}

