/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.item;

import com.piglinmine.fastpipes.network.FastPipesNetwork;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.item.ItemNetwork;
import com.piglinmine.fastpipes.network.message.ItemTransportMessage;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipeType;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransport;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransportProps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ItemPipe
extends Pipe {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"item");
    private final List<ItemTransport> transports = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToAdd = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToRemove = new ArrayList<ItemTransport>();
    private final ItemPipeType type;

    public ItemPipe(Level level, BlockPos pos, ItemPipeType type) {
        super(level, pos);
        this.type = type;
    }

    public ItemPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
        tag.putInt("type", this.type.ordinal());
        ListTag transports = new ListTag();
        for (ItemTransport transport : this.transports) {
            transports.add((Object)transport.writeToNbt(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
        }
        tag.put("transports", (Tag)transports);
        return tag;
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return ItemNetwork.TYPE;
    }

    @Override
    public void update() {
        super.update();
        boolean structureChanged = false;
        if (!this.transportsToAdd.isEmpty()) {
            this.transports.addAll(this.transportsToAdd);
            structureChanged = true;
        }
        if (!this.transportsToRemove.isEmpty()) {
            this.transports.removeAll(this.transportsToRemove);
            structureChanged = true;
        }
        if (structureChanged) {
            NetworkManager.get(this.level).setDirty();
            this.sendTransportUpdate();
        }
        this.transportsToAdd.clear();
        this.transportsToRemove.clear();
        if (this.transports.removeIf(t -> t.update(this.network, this))) {
            NetworkManager.get(this.level).setDirty();
            this.sendTransportUpdate();
        }
    }

    public List<ItemTransport> getTransports() {
        return this.transports;
    }

    public void addTransport(ItemTransport transport) {
        this.transportsToAdd.add(transport);
    }

    public void removeTransport(ItemTransport transport) {
        this.transportsToRemove.add(transport);
    }

    public void sendTransportUpdate() {
        ArrayList<ItemTransportProps> props = new ArrayList<ItemTransportProps>();
        for (ItemTransport transport : this.transports) {
            props.add(transport.createProps(this));
        }
        FastPipesNetwork.sendInArea(this.level, this.pos, 32, new ItemTransportMessage(this.pos, props));
    }

    public int getMaxTicksInPipe() {
        return this.type.getMaxTicksInPipe();
    }
}

