/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.item;

import net.minecraft.resources.ResourceLocation;

public enum ItemPipeType {
    BASIC(0),
    IMPROVED(1),
    ADVANCED(2);

    private final int tier;

    private ItemPipeType(int tier) {
        this.tier = tier;
    }

    public static ItemPipeType get(int ordinal) {
        ItemPipeType[] values = ItemPipeType.values();
        if (ordinal < 0 || ordinal >= values.length) {
            return BASIC;
        }
        return values[ordinal];
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxTicksInPipe() {
        switch (this.ordinal()) {
            case 0: {
                return 20;
            }
            case 1: {
                return 15;
            }
            case 2: {
                return 10;
            }
        }
        throw new RuntimeException("Unknown ItemPipeType: " + String.valueOf((Object)this));
    }

    public ResourceLocation getId() {
        switch (this.ordinal()) {
            case 0: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"basic_item_pipe");
            }
            case 1: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"improved_item_pipe");
            }
            case 2: {
                return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"advanced_item_pipe");
            }
        }
        throw new RuntimeException("Unknown ItemPipeType: " + String.valueOf((Object)this));
    }

    public ResourceLocation getNetworkType() {
        return ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("item_" + this.name().toLowerCase()));
    }
}

