/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.shape;

import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.item.AttachmentItem;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeFactory;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeProps;
import com.piglinmine.fastpipes.util.Raytracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class PipeShapeCache {
    private static final ResourceLocation[] NO_ATTACHMENT_STATE = new ResourceLocation[Direction.values().length];
    private final PipeShapeFactory shapeFactory;
    private final List<AABB> attachmentShapes = new ArrayList<AABB>();
    private final Map<PipeShapeCacheEntry, VoxelShape> cache = new HashMap<PipeShapeCacheEntry, VoxelShape>();

    public PipeShapeCache(PipeShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
        this.attachmentShapes.add(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.bounds());
        this.attachmentShapes.add(PipeShapeProps.EAST_ATTACHMENT_SHAPE.bounds());
        this.attachmentShapes.add(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.bounds());
        this.attachmentShapes.add(PipeShapeProps.WEST_ATTACHMENT_SHAPE.bounds());
        this.attachmentShapes.add(PipeShapeProps.UP_ATTACHMENT_SHAPE.bounds());
        this.attachmentShapes.add(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.bounds());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Player player;
        Item inHand;
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        VoxelShape shape = this.createShapeIfNeeded(state, world, pos);
        if (ctx instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)ctx).getEntity()) instanceof Player && (inHand = (player = (Player)entity).getMainHandItem().getItem()) instanceof AttachmentItem) {
            shape = this.addFakeAttachmentShape(state.getBlock(), pos, (Entity)player, shape, ((AttachmentItem)inHand).getFactory());
        }
        return shape;
    }

    private VoxelShape addFakeAttachmentShape(Block block, BlockPos pos, Entity entity, VoxelShape shape, AttachmentFactory type) {
        if (!type.canPlaceOnPipe(block)) {
            return shape;
        }
        Pair<Vec3, Vec3> vec = Raytracer.getVectors(entity);
        Raytracer.AdvancedRayTraceResult<BlockHitResult> result = Raytracer.collisionRayTrace(pos, (Vec3)vec.getLeft(), (Vec3)vec.getRight(), this.attachmentShapes);
        if (result != null) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)result.bounds));
        }
        return shape;
    }

    private VoxelShape createShapeIfNeeded(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        ResourceLocation[] attachmentState = blockEntity instanceof PipeBlockEntity ? ((PipeBlockEntity)blockEntity).getAttachmentManager().getState() : NO_ATTACHMENT_STATE;
        PipeShapeCacheEntry entry = new PipeShapeCacheEntry(state, attachmentState);
        return this.cache.computeIfAbsent(entry, e -> this.shapeFactory.createShape(e.getState(), e.getAttachmentState()));
    }

    public static class PipeShapeCacheEntry {
        private final BlockState state;
        private final ResourceLocation[] attachmentState;

        public PipeShapeCacheEntry(BlockState state, ResourceLocation[] attachmentState) {
            this.state = state;
            this.attachmentState = (ResourceLocation[])attachmentState.clone();
        }

        public BlockState getState() {
            return this.state;
        }

        public ResourceLocation[] getAttachmentState() {
            return this.attachmentState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipeShapeCacheEntry that = (PipeShapeCacheEntry)o;
            return Objects.equals(this.state, that.state) && Arrays.equals(this.attachmentState, that.attachmentState);
        }

        public int hashCode() {
            int result = Objects.hash(this.state);
            result = 31 * result + Arrays.hashCode(this.attachmentState);
            return result;
        }
    }
}

