/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipe;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransportProps;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallbackFactoryRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemTransport {
    private static final Logger LOGGER = LogManager.getLogger(ItemTransport.class);
    private final ItemStack value;
    private final BlockPos source;
    private final BlockPos destination;
    private final Deque<BlockPos> path;
    private final Direction initialDirection;
    private final TransportCallback finishedCallback;
    private final TransportCallback cancelCallback;
    private final TransportCallback pipeGoneCallback;
    private boolean firstPipe = true;
    private int progressInCurrentPipe;

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = ItemTransport.getDirection(source, path.peek());
        this.path.poll();
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
    }

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, Direction initialDirection, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback, boolean firstPipe, int progressInCurrentPipe) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = initialDirection;
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
        this.firstPipe = firstPipe;
        this.progressInCurrentPipe = progressInCurrentPipe;
    }

    private static Direction getDirection(BlockPos a, BlockPos b) {
        if (a.relative(Direction.NORTH).equals((Object)b)) {
            return Direction.NORTH;
        }
        if (a.relative(Direction.EAST).equals((Object)b)) {
            return Direction.EAST;
        }
        if (a.relative(Direction.SOUTH).equals((Object)b)) {
            return Direction.SOUTH;
        }
        if (a.relative(Direction.WEST).equals((Object)b)) {
            return Direction.WEST;
        }
        if (a.relative(Direction.UP).equals((Object)b)) {
            return Direction.UP;
        }
        if (a.relative(Direction.DOWN).equals((Object)b)) {
            return Direction.DOWN;
        }
        return Direction.NORTH;
    }

    @Nullable
    public static ItemTransport of(CompoundTag tag, HolderLookup.Provider registries) {
        ItemStack value = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("v"));
        if (value.isEmpty()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        BlockPos source = BlockPos.of((long)tag.getLong("src"));
        BlockPos destination = BlockPos.of((long)tag.getLong("dst"));
        ListTag pathTag = tag.getList("pth", 4);
        ArrayDeque<BlockPos> path = new ArrayDeque<BlockPos>();
        for (Tag pathItem : pathTag) {
            path.add(BlockPos.of((long)((LongTag)pathItem).getAsLong()));
        }
        Direction initialDirection = Direction.values()[tag.getInt("initd")];
        ResourceLocation finishedCallbackId = ResourceLocation.parse((String)tag.getString("fcid"));
        TransportCallback finishedCallback = TransportCallbackFactoryRegistry.createCallback(finishedCallbackId, tag.getCompound("fc"));
        ResourceLocation cancelCallbackId = ResourceLocation.parse((String)tag.getString("ccid"));
        TransportCallback cancelCallback = TransportCallbackFactoryRegistry.createCallback(cancelCallbackId, tag.getCompound("cc"));
        ResourceLocation pipeGoneCallbackId = ResourceLocation.parse((String)tag.getString("pgcid"));
        TransportCallback pipeGoneCallback = TransportCallbackFactoryRegistry.createCallback(pipeGoneCallbackId, tag.getCompound("pgc"));
        boolean firstPipe = tag.getBoolean("fp");
        int progressInCurrentPipe = tag.getInt("p");
        return new ItemTransport(value, source, destination, path, initialDirection, finishedCallback, cancelCallback, pipeGoneCallback, firstPipe, progressInCurrentPipe);
    }

    public ItemStack getValue() {
        return this.value;
    }

    public Direction getDirection(ItemPipe currentPipe) {
        BlockPos nextPipe = this.path.peek();
        if (nextPipe == null) {
            return ItemTransport.getDirection(currentPipe.getPos(), this.destination);
        }
        return ItemTransport.getDirection(currentPipe.getPos(), nextPipe);
    }

    private boolean onDone(Network network, Level level, ItemPipe currentPipe) {
        this.finishedCallback.call(network, level, currentPipe.getPos(), this.cancelCallback);
        return true;
    }

    private boolean onPipeGone(Network network, Level level, BlockPos posWherePipeIsGone) {
        LOGGER.warn("Pipe on path is gone");
        this.pipeGoneCallback.call(network, level, posWherePipeIsGone, this.cancelCallback);
        return true;
    }

    public boolean update(Network network, ItemPipe currentPipe) {
        ++this.progressInCurrentPipe;
        double progress = (double)this.progressInCurrentPipe / (double)this.getMaxTicksInPipe(currentPipe);
        BlockPos nextPos = currentPipe.getPos().relative(this.getDirection(currentPipe));
        if (progress > 0.25 && currentPipe.getLevel().isEmptyBlock(nextPos)) {
            currentPipe.removeTransport(this);
            return this.onPipeGone(network, currentPipe.getLevel(), nextPos);
        }
        if (this.progressInCurrentPipe >= this.getMaxTicksInPipe(currentPipe)) {
            currentPipe.removeTransport(this);
            this.firstPipe = false;
            BlockPos nextPipePos = this.path.poll();
            if (nextPipePos == null) {
                return this.onDone(network, currentPipe.getLevel(), currentPipe);
            }
            Pipe nextPipe = network.getPipe(nextPipePos);
            if (nextPipe == null) {
                return this.onPipeGone(network, currentPipe.getLevel(), nextPipePos);
            }
            this.progressInCurrentPipe = 0;
            ((ItemPipe)nextPipe).addTransport(this);
        }
        return false;
    }

    private boolean isLastPipe() {
        return this.path.isEmpty();
    }

    private int getMaxTicksInPipe(ItemPipe currentPipe) {
        double mt = currentPipe.getMaxTicksInPipe();
        if (this.firstPipe) {
            mt *= 1.25;
        }
        if (this.isLastPipe()) {
            mt *= 0.25;
        }
        return (int)mt;
    }

    public ItemTransportProps createProps(ItemPipe currentPipe) {
        return new ItemTransportProps(this.value, this.getMaxTicksInPipe(currentPipe), this.progressInCurrentPipe, this.getDirection(currentPipe), this.initialDirection, this.isLastPipe(), this.firstPipe);
    }

    public CompoundTag writeToNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("v", this.value.saveOptional(registries));
        tag.putLong("src", this.source.asLong());
        tag.putLong("dst", this.destination.asLong());
        ListTag path = new ListTag();
        for (BlockPos pathItem : this.path) {
            path.add((Object)LongTag.valueOf((long)pathItem.asLong()));
        }
        tag.put("pth", (Tag)path);
        tag.putInt("initd", this.initialDirection.ordinal());
        tag.put("fc", (Tag)this.finishedCallback.writeToNbt(new CompoundTag()));
        tag.putString("fcid", this.finishedCallback.getId().toString());
        tag.put("cc", (Tag)this.cancelCallback.writeToNbt(new CompoundTag()));
        tag.putString("ccid", this.cancelCallback.getId().toString());
        tag.put("pgc", (Tag)this.pipeGoneCallback.writeToNbt(new CompoundTag()));
        tag.putString("pgcid", this.pipeGoneCallback.getId().toString());
        tag.putBoolean("fp", this.firstPipe);
        tag.putInt("p", this.progressInCurrentPipe);
        return tag;
    }

    public ItemStack getStack() {
        return this.value;
    }

    public void tick() {
        ++this.progressInCurrentPipe;
    }
}

