/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport;

import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ItemTransportProps {
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemTransportProps> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemTransportProps>(){

        public void encode(RegistryFriendlyByteBuf buffer, ItemTransportProps props) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)props.stack);
            buffer.writeInt(props.maxTicksInPipe);
            buffer.writeInt(props.progress);
            buffer.writeEnum((Enum)props.direction);
            buffer.writeEnum((Enum)props.initialDirection);
            buffer.writeBoolean(props.firstPipe);
            buffer.writeBoolean(props.lastPipe);
        }

        public ItemTransportProps decode(RegistryFriendlyByteBuf buffer) {
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int maxTicksInPipe = buffer.readInt();
            int progress = buffer.readInt();
            Direction direction = (Direction)buffer.readEnum(Direction.class);
            Direction initialDirection = (Direction)buffer.readEnum(Direction.class);
            boolean firstPipe = buffer.readBoolean();
            boolean lastPipe = buffer.readBoolean();
            return new ItemTransportProps(stack, maxTicksInPipe, progress, direction, initialDirection, firstPipe, lastPipe);
        }
    };
    private final ItemStack stack;
    private final int maxTicksInPipe;
    private int progress;
    private final Direction direction;
    private final Direction initialDirection;
    private final boolean firstPipe;
    private final boolean lastPipe;

    public ItemTransportProps(ItemStack stack, int maxTicksInPipe, int progress, Direction direction, Direction initialDirection, boolean firstPipe, boolean lastPipe) {
        this.stack = stack;
        this.maxTicksInPipe = maxTicksInPipe;
        this.progress = progress;
        this.direction = direction;
        this.initialDirection = initialDirection;
        this.firstPipe = firstPipe;
        this.lastPipe = lastPipe;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getMaxTicksInPipe() {
        return this.maxTicksInPipe;
    }

    public int getProgress() {
        return this.progress;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Direction getInitialDirection() {
        return this.initialDirection;
    }

    public boolean isFirstPipe() {
        return this.firstPipe;
    }

    public boolean isLastPipe() {
        return this.lastPipe;
    }

    public void tick() {
        ++this.progress;
    }
}

