/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport.callback;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallback;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemBounceBackTransportCallback
implements TransportCallback {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"item_bounce_back");
    private static final Logger LOGGER = LogManager.getLogger(ItemBounceBackTransportCallback.class);
    private final BlockPos originalItemHandlerPosition;
    private final BlockPos bounceBackItemHandlerPosition;
    private final ItemStack toInsert;

    public ItemBounceBackTransportCallback(BlockPos originalItemHandlerPosition, BlockPos bounceBackItemHandlerPosition, ItemStack toInsert) {
        this.originalItemHandlerPosition = originalItemHandlerPosition;
        this.bounceBackItemHandlerPosition = bounceBackItemHandlerPosition;
        this.toInsert = toInsert;
    }

    @Nullable
    public static ItemBounceBackTransportCallback of(CompoundTag tag, HolderLookup.Provider registries) {
        BlockPos originalItemHandlerPosition = BlockPos.of((long)tag.getLong("oihpos"));
        BlockPos bounceBackItemHandlerPosition = BlockPos.of((long)tag.getLong("bbihpos"));
        ItemStack toInsert = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("s"));
        if (toInsert.isEmpty()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemBounceBackTransportCallback(originalItemHandlerPosition, bounceBackItemHandlerPosition, toInsert);
    }

    @Override
    public void call(Network network, Level level, BlockPos currentPos, TransportCallback cancelCallback) {
        Containers.dropItemStack((Level)level, (double)this.originalItemHandlerPosition.getX(), (double)this.originalItemHandlerPosition.getY(), (double)this.originalItemHandlerPosition.getZ(), (ItemStack)this.toInsert);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putLong("oihpos", this.originalItemHandlerPosition.asLong());
        tag.putLong("bbihpos", this.bounceBackItemHandlerPosition.asLong());
        tag.put("s", (Tag)new CompoundTag());
        return tag;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("oihpos", this.originalItemHandlerPosition.asLong());
        tag.putLong("bbihpos", this.bounceBackItemHandlerPosition.asLong());
        tag.put("s", this.toInsert.saveOptional(registries));
        return tag;
    }
}

