/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport.callback;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallback;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemInsertTransportCallback
implements TransportCallback {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"item_insert");
    private static final Logger LOGGER = LogManager.getLogger(ItemInsertTransportCallback.class);
    private final BlockPos itemHandlerPosition;
    private final Direction incomingDirection;
    private final ItemStack toInsert;

    public ItemInsertTransportCallback(BlockPos itemHandlerPosition, Direction incomingDirection, ItemStack toInsert) {
        this.itemHandlerPosition = itemHandlerPosition;
        this.incomingDirection = incomingDirection;
        this.toInsert = toInsert;
    }

    @Nullable
    public static ItemInsertTransportCallback of(CompoundTag tag, HolderLookup.Provider registries) {
        BlockPos itemHandlerPosition = BlockPos.of((long)tag.getLong("ihpos"));
        ItemStack toInsert = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("s"));
        Direction incomingDirection = Direction.values()[tag.getInt("incdir")];
        if (toInsert.isEmpty()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemInsertTransportCallback(itemHandlerPosition, incomingDirection, toInsert);
    }

    @Override
    public void call(Network network, Level level, BlockPos currentPos, TransportCallback cancelCallback) {
        BlockEntity blockEntity = level.getBlockEntity(this.itemHandlerPosition);
        if (blockEntity == null) {
            LOGGER.warn("Destination item handler is gone at " + String.valueOf(this.itemHandlerPosition));
            cancelCallback.call(network, level, currentPos, cancelCallback);
            return;
        }
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, this.itemHandlerPosition, (Object)this.incomingDirection.getOpposite());
        if (itemHandler == null) {
            LOGGER.warn("Destination item handler is no longer exposing a capability at " + String.valueOf(this.itemHandlerPosition));
            cancelCallback.call(network, level, currentPos, cancelCallback);
            return;
        }
        if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)true).isEmpty()) {
            ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)false);
        } else {
            cancelCallback.call(network, level, currentPos, cancelCallback);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.putLong("ihpos", this.itemHandlerPosition.asLong());
        tag.put("s", (Tag)new CompoundTag());
        tag.putInt("incdir", this.incomingDirection.ordinal());
        return tag;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("ihpos", this.itemHandlerPosition.asLong());
        tag.put("s", this.toInsert.saveOptional(registries));
        tag.putInt("incdir", this.incomingDirection.ordinal());
        return tag;
    }
}

