/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport.callback;

import com.piglinmine.fastpipes.network.Network;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallback;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemPipeGoneTransportCallback
implements TransportCallback {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"item_pipe_gone");
    private static final Logger LOGGER = LogManager.getLogger(ItemPipeGoneTransportCallback.class);
    private final ItemStack stack;

    public ItemPipeGoneTransportCallback(ItemStack stack) {
        this.stack = stack;
    }

    @Nullable
    public static ItemPipeGoneTransportCallback of(CompoundTag tag, HolderLookup.Provider registries) {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("s"));
        if (stack.isEmpty()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemPipeGoneTransportCallback(stack);
    }

    @Override
    public void call(Network network, Level level, BlockPos currentPos, TransportCallback cancelCallback) {
        Containers.dropItemStack((Level)level, (double)currentPos.getX(), (double)currentPos.getY(), (double)currentPos.getZ(), (ItemStack)this.stack);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.put("s", (Tag)new CompoundTag());
        return tag;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("s", this.stack.saveOptional(registries));
        return tag;
    }
}

