/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.network.pipe.transport.callback;

import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemBounceBackTransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemBounceBackTransportCallbackFactory;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemInsertTransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemInsertTransportCallbackFactory;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallbackFactory;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallback;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallbackFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportCallbackFactoryRegistry {
    public static final TransportCallbackFactoryRegistry INSTANCE = new TransportCallbackFactoryRegistry();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, TransportCallbackFactory> factories = new HashMap<ResourceLocation, TransportCallbackFactory>();
    private boolean initialized = false;

    private TransportCallbackFactoryRegistry() {
    }

    public void initialize(HolderLookup.Provider registries) {
        if (this.initialized) {
            return;
        }
        this.addFactory(ItemInsertTransportCallback.ID, new ItemInsertTransportCallbackFactory(registries));
        this.addFactory(ItemPipeGoneTransportCallback.ID, new ItemPipeGoneTransportCallbackFactory(registries));
        this.addFactory(ItemBounceBackTransportCallback.ID, new ItemBounceBackTransportCallbackFactory(registries));
        this.initialized = true;
        LOGGER.info("Initialized transport callback factories");
    }

    public void addFactory(ResourceLocation id, TransportCallbackFactory factory) {
        if (this.factories.containsKey(id)) {
            throw new RuntimeException("Cannot register duplicate transport callback factory " + id.toString());
        }
        this.factories.put(id, factory);
    }

    @Nullable
    public TransportCallbackFactory getFactory(ResourceLocation id) {
        return this.factories.get(id);
    }

    @Nullable
    public static TransportCallback createCallback(ResourceLocation id, CompoundTag tag) {
        TransportCallbackFactory factory = INSTANCE.getFactory(id);
        if (factory == null) {
            LOGGER.warn("Transport callback factory " + String.valueOf(id) + " no longer exists");
            return null;
        }
        TransportCallback callback = factory.create(tag);
        if (callback == null) {
            LOGGER.warn("Transport callback factory " + String.valueOf(id) + " returned null!");
            return null;
        }
        return callback;
    }
}

