/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class CubeBuilder {
    public static final CubeBuilder INSTANCE = new CubeBuilder();
    private final byte[] uvRotations = new byte[Direction.values().length];

    private CubeBuilder() {
    }

    public void putCube(PoseStack poseStack, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite) {
        this.putCube(poseStack, builder, x1, y1, z1, x2, y2, z2, r, g, b, a, light, sprite, null);
    }

    public void putCube(PoseStack poseStack, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite, @Nullable Direction exclude) {
        poseStack.pushPose();
        for (Direction face : Direction.values()) {
            if (face == exclude) continue;
            this.putFace(poseStack, builder, x1, y1, z1, x2, y2, z2, r, g, b, a, light, sprite, face);
        }
        poseStack.popPose();
    }

    public void putFace(PoseStack poseStack, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite, Direction face) {
        UvVector uv = this.getDefaultUv(face, sprite, x1, y1, z1, x2, y2, z2);
        switch (face) {
            case DOWN: {
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x2, y1, z1, uv);
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x1, y1, z1, uv);
                break;
            }
            case UP: {
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x1, y2, z1, uv);
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x2, y2, z2, uv);
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x2, y2, z1, uv);
                break;
            }
            case NORTH: {
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x2, y2, z1, uv);
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x2, y1, z1, uv);
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x1, y1, z1, uv);
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x1, y2, z1, uv);
                break;
            }
            case SOUTH: {
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x2, y2, z2, uv);
                break;
            }
            case WEST: {
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x1, y1, z1, uv);
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x1, y2, z1, uv);
                break;
            }
            case EAST: {
                this.putVertexBR(builder, poseStack, face, r, g, b, a, light, x2, y2, z1, uv);
                this.putVertexBL(builder, poseStack, face, r, g, b, a, light, x2, y2, z2, uv);
                this.putVertexTL(builder, poseStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexTR(builder, poseStack, face, r, g, b, a, light, x2, y1, z1, uv);
            }
        }
    }

    private UvVector getDefaultUv(Direction face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.getU(x1 * 16.0f);
                uv.v1 = texture.getV(z1 * 16.0f);
                uv.u2 = texture.getU(x2 * 16.0f);
                uv.v2 = texture.getV(z2 * 16.0f);
                break;
            }
            case UP: {
                uv.u1 = texture.getU(x1 * 16.0f);
                uv.v1 = texture.getV(z1 * 16.0f);
                uv.u2 = texture.getU(x2 * 16.0f);
                uv.v2 = texture.getV(z2 * 16.0f);
                break;
            }
            case NORTH: {
                uv.u1 = texture.getU(x1 * 16.0f);
                uv.v1 = texture.getV(16.0f - y1 * 16.0f);
                uv.u2 = texture.getU(x2 * 16.0f);
                uv.v2 = texture.getV(16.0f - y2 * 16.0f);
                break;
            }
            case SOUTH: {
                uv.u1 = texture.getU(x1 * 16.0f);
                uv.v1 = texture.getV(16.0f - y1 * 16.0f);
                uv.u2 = texture.getU(x2 * 16.0f);
                uv.v2 = texture.getV(16.0f - y2 * 16.0f);
                break;
            }
            case WEST: {
                uv.u1 = texture.getU(z1 * 16.0f);
                uv.v1 = texture.getV(16.0f - y1 * 16.0f);
                uv.u2 = texture.getU(z2 * 16.0f);
                uv.v2 = texture.getV(16.0f - y2 * 16.0f);
                break;
            }
            case EAST: {
                uv.u1 = texture.getU(z2 * 16.0f);
                uv.v1 = texture.getV(16.0f - y1 * 16.0f);
                uv.u2 = texture.getU(z1 * 16.0f);
                uv.v2 = texture.getV(16.0f - y2 * 16.0f);
            }
        }
        return uv;
    }

    private void putVertexTL(VertexConsumer builder, PoseStack poseStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, poseStack, r, g, b, a, light, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 1 -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 2 -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 3 -> {
                u = uv.u2;
                yield uv.v1;
            }
        });
    }

    private void putVertexTR(VertexConsumer builder, PoseStack poseStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, poseStack, r, g, b, a, light, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 1 -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 2 -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 3 -> {
                u = uv.u2;
                yield uv.v2;
            }
        });
    }

    private void putVertexBR(VertexConsumer builder, PoseStack poseStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, poseStack, r, g, b, a, light, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 1 -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 2 -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 3 -> {
                u = uv.u1;
                yield uv.v2;
            }
        });
    }

    private void putVertexBL(VertexConsumer builder, PoseStack poseStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, poseStack, r, g, b, a, light, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 1 -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 2 -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 3 -> {
                u = uv.u1;
                yield uv.v1;
            }
        });
    }

    private void putVertex(VertexConsumer builder, PoseStack poseStack, int r, int g, int b, int a, int light, float x, float y, float z, float u, float v) {
        builder.addVertex(poseStack.last(), x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

