/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.piglinmine.fastpipes.blockentity.ItemPipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.transport.ItemTransportProps;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;

public class ItemPipeBlockEntityRenderer
implements BlockEntityRenderer<ItemPipeBlockEntity> {
    public ItemPipeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ItemPipeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferType, int combinedLight, int combinedOverlay) {
        if (blockEntity.getProps().isEmpty()) {
            return;
        }
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getBlockPos();
        long gameTime = level.getGameTime();
        for (ItemTransportProps prop : blockEntity.getProps()) {
            Direction dir = prop.getDirection();
            double pipeLength = 1.0;
            if (prop.isFirstPipe()) {
                pipeLength = 1.25;
            }
            if (prop.isLastPipe()) {
                pipeLength = 0.25;
            }
            double maxTicksInPipe = (double)prop.getMaxTicksInPipe() * pipeLength;
            double v = ((double)prop.getProgress() + (double)partialTicks) / maxTicksInPipe * pipeLength;
            if (prop.isFirstPipe() && v < 0.25) {
                dir = prop.getInitialDirection();
            }
            if (prop.isFirstPipe()) {
                v -= 0.25;
            }
            if (v > 0.25 && level.isEmptyBlock(blockPos.relative(prop.getDirection()))) continue;
            v = Math.min(1.0, v);
            poseStack.pushPose();
            poseStack.translate(0.5 + (double)dir.getStepX() * v, 0.5 + (double)dir.getStepY() * v, 0.5 + (double)dir.getStepZ() * v);
            float rotationTime = (float)((double)gameTime / 25.0 % (Math.PI * 2) + (double)partialTicks / 25.0);
            poseStack.mulPose(Axis.YP.rotation(rotationTime));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(prop.getStack(), ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferType, level, 0);
            poseStack.popPose();
        }
    }
}

