/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.render;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import com.piglinmine.fastpipes.block.PipeBlock;
import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.render.PipeState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PipeBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogManager.getLogger(PipeBakedModel.class);
    private static final Map<Direction, Transformation> SIDE_TRANSFORMS = new EnumMap<Direction, Transformation>(Direction.class);
    private final BakedModel core;
    private final BakedModel extension;
    private final BakedModel straight;
    private final BakedModel inventoryAttachment;
    private final Map<ResourceLocation, BakedModel> attachmentModels;
    private final Map<PipeState, List<BakedQuad>> cache = new ConcurrentHashMap<PipeState, List<BakedQuad>>();

    public PipeBakedModel(BakedModel core, BakedModel extension, BakedModel straight, BakedModel inventoryAttachment, Map<ResourceLocation, BakedModel> attachmentModels) {
        this.core = core;
        this.extension = extension;
        this.straight = straight;
        this.inventoryAttachment = inventoryAttachment;
        this.attachmentModels = attachmentModels;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        ResourceLocation[] attachmentState = (ResourceLocation[])extraData.get(PipeBlockEntity.ATTACHMENTS_PROPERTY);
        PipeState pipeState = new PipeState(state, attachmentState, side, rand);
        return this.cache.computeIfAbsent(pipeState, this::createQuads);
    }

    private List<BakedQuad> createQuads(PipeState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state.getState() != null) {
            boolean north = (Boolean)state.getState().getValue((Property)PipeBlock.NORTH);
            int east = ((Boolean)state.getState().getValue((Property)PipeBlock.EAST)).booleanValue();
            int south = ((Boolean)state.getState().getValue((Property)PipeBlock.SOUTH)).booleanValue() ? 1 : 0;
            boolean west = (Boolean)state.getState().getValue((Property)PipeBlock.WEST);
            boolean up = (Boolean)state.getState().getValue((Property)PipeBlock.UP);
            boolean down = (Boolean)state.getState().getValue((Property)PipeBlock.DOWN);
            if (north && south != 0 && east == 0 && !west && !up && !down) {
                quads.addAll(this.straight.getQuads(state.getState(), state.getSide(), state.getRand(), ModelData.EMPTY, null));
            } else if (!north && south == 0 && east != 0 && west && !up && !down) {
                quads.addAll(this.getTransformedQuads(this.straight, Direction.EAST, state));
            } else if (!north && south == 0 && east == 0 && !west && up && down) {
                quads.addAll(this.getTransformedQuads(this.straight, Direction.UP, state));
            } else if (!(north || south != 0 || east != 0 || west || up || down)) {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), ModelData.EMPTY, null));
            } else {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), ModelData.EMPTY, null));
                if (north) {
                    quads.addAll(this.extension.getQuads(state.getState(), state.getSide(), state.getRand(), ModelData.EMPTY, null));
                }
                if (east != 0) {
                    quads.addAll(this.getTransformedQuads(this.extension, Direction.EAST, state));
                }
                if (south != 0) {
                    quads.addAll(this.getTransformedQuads(this.extension, Direction.SOUTH, state));
                }
                if (west) {
                    quads.addAll(this.getTransformedQuads(this.extension, Direction.WEST, state));
                }
                if (up) {
                    quads.addAll(this.getTransformedQuads(this.extension, Direction.UP, state));
                }
                if (down) {
                    quads.addAll(this.getTransformedQuads(this.extension, Direction.DOWN, state));
                }
            }
        }
        if (state.getAttachmentState() != null) {
            LOGGER.debug("Processing attachments for pipe at state: {}", (Object)Arrays.toString(state.getAttachmentState()));
            for (Direction dir : Direction.values()) {
                ResourceLocation attachmentId = state.getAttachmentState()[dir.ordinal()];
                if (attachmentId == null) continue;
                LOGGER.debug("Found attachment {} in direction {}", (Object)attachmentId, (Object)dir);
                BakedModel attachmentModel = this.attachmentModels.get(attachmentId);
                if (attachmentModel != null) {
                    LOGGER.debug("Adding attachment model for {} in direction {}", (Object)attachmentId, (Object)dir);
                    quads.addAll(this.getTransformedQuads(attachmentModel, dir, state));
                    continue;
                }
                LOGGER.warn("No attachment model found for ID: {}", (Object)attachmentId);
            }
        } else {
            LOGGER.debug("No attachment state found for pipe");
        }
        if (state.getState() != null) {
            boolean invNorth = (Boolean)state.getState().getValue((Property)PipeBlock.INV_NORTH);
            boolean invEast = (Boolean)state.getState().getValue((Property)PipeBlock.INV_EAST);
            boolean invSouth = (Boolean)state.getState().getValue((Property)PipeBlock.INV_SOUTH);
            boolean invWest = (Boolean)state.getState().getValue((Property)PipeBlock.INV_WEST);
            boolean invUp = (Boolean)state.getState().getValue((Property)PipeBlock.INV_UP);
            boolean invDown = (Boolean)state.getState().getValue((Property)PipeBlock.INV_DOWN);
            if (invNorth && !state.hasAttachmentState(Direction.NORTH)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.NORTH, state));
            }
            if (invEast && !state.hasAttachmentState(Direction.EAST)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.EAST, state));
            }
            if (invSouth && !state.hasAttachmentState(Direction.SOUTH)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.SOUTH, state));
            }
            if (invWest && !state.hasAttachmentState(Direction.WEST)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.WEST, state));
            }
            if (invUp && !state.hasAttachmentState(Direction.UP)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.UP, state));
            }
            if (invDown && !state.hasAttachmentState(Direction.DOWN)) {
                quads.addAll(this.getTransformedQuads(this.inventoryAttachment, Direction.DOWN, state));
            }
        }
        return quads;
    }

    private List<BakedQuad> getTransformedQuads(BakedModel model, Direction facing, PipeState state) {
        Transformation transformation = SIDE_TRANSFORMS.computeIfAbsent(facing, face -> {
            Quaternionf quaternion;
            if (face == Direction.UP) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(90.0f, 0.0f, 0.0f), (boolean)true);
            } else if (face == Direction.DOWN) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(270.0f, 0.0f, 0.0f), (boolean)true);
            } else {
                double r = Math.PI * (double)(360 - face.getOpposite().get2DDataValue() * 90) / 180.0;
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false);
            }
            return BlockMath.blockCenterToCorner((Transformation)new Transformation(null, quaternion, null, null));
        });
        ImmutableList.Builder quads = ImmutableList.builder();
        Direction side = state.getSide();
        if (side != null && side.get2DDataValue() > -1) {
            int faceOffset = 4 + Direction.NORTH.get2DDataValue() - facing.get2DDataValue();
            side = Direction.from2DDataValue((int)((side.get2DDataValue() + faceOffset) % 4));
        }
        IQuadTransformer transformer = QuadTransformers.applying((Transformation)transformation);
        for (BakedQuad quad : model.getQuads(state.getState(), side, state.getRand(), ModelData.EMPTY, null)) {
            BakedQuad transformedQuad = transformer.process(quad);
            quads.add((Object)transformedQuad);
        }
        return quads.build();
    }

    public boolean useAmbientOcclusion() {
        return this.core.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.core.isGui3d();
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return this.core.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        return this.core.getParticleIcon(modelData);
    }

    public ItemOverrides getOverrides() {
        return this.core.getOverrides();
    }

    public ItemTransforms getTransforms() {
        return this.core.getTransforms();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return List.of(RenderType.cutout());
    }
}

