/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.render;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class PipeState {
    @Nullable
    private final BlockState state;
    @Nullable
    private final ResourceLocation[] attachmentState;
    private final Direction side;
    private final RandomSource rand;

    public PipeState(@Nullable BlockState state, @Nullable ResourceLocation[] attachmentState, Direction side, RandomSource rand) {
        this.state = state;
        this.attachmentState = attachmentState;
        this.side = side;
        this.rand = rand;
    }

    @Nullable
    public BlockState getState() {
        return this.state;
    }

    @Nullable
    public ResourceLocation[] getAttachmentState() {
        return this.attachmentState;
    }

    @Nullable
    public ResourceLocation getAttachmentState(Direction direction) {
        if (this.attachmentState == null) {
            return null;
        }
        return this.attachmentState[direction.ordinal()];
    }

    public boolean hasAttachmentState(Direction direction) {
        return this.getAttachmentState(direction) != null;
    }

    public Direction getSide() {
        return this.side;
    }

    public RandomSource getRand() {
        return this.rand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeState pipeState = (PipeState)o;
        return Objects.equals(this.state, pipeState.state) && Arrays.equals(this.attachmentState, pipeState.attachmentState) && this.side == pipeState.side;
    }

    public int hashCode() {
        int result = Objects.hash(this.state, this.side);
        result = 31 * result + Arrays.hashCode(this.attachmentState);
        return result;
    }
}

