/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.screen;

import com.piglinmine.fastpipes.menu.ExtractorAttachmentContainerMenu;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.RoutingMode;
import com.piglinmine.fastpipes.screen.BaseScreen;
import com.piglinmine.fastpipes.screen.widget.IconButton;
import com.piglinmine.fastpipes.screen.widget.IconButtonPreset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ExtractorAttachmentScreen
extends BaseScreen<ExtractorAttachmentContainerMenu> {
    private static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"textures/gui/extractor_attachment.png");
    private final List<Component> tooltip = new ArrayList<Component>();
    private Button redstoneModeButton;
    private Button blacklistWhitelistButton;
    @Nullable
    private Button routingModeButton;
    @Nullable
    private Button exactModeButton;
    @Nullable
    private Button plusButton;
    @Nullable
    private Button minusButton;

    public ExtractorAttachmentScreen(ExtractorAttachmentContainerMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 193;
    }

    protected void init() {
        super.init();
        this.redstoneModeButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 32, this.topPos + 76, IconButtonPreset.NORMAL, this.getRedstoneModeX(((ExtractorAttachmentContainerMenu)this.menu).getRedstoneMode()), 61, (Component)this.getRedstoneModeText(((ExtractorAttachmentContainerMenu)this.menu).getRedstoneMode()), btn -> this.setRedstoneMode((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.menu).getRedstoneMode().next())));
        this.redstoneModeButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getCanSetRedstoneMode();
        this.blacklistWhitelistButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 55, this.topPos + 76, IconButtonPreset.NORMAL, this.getBlacklistWhitelistX(((ExtractorAttachmentContainerMenu)this.menu).getBlacklistWhitelist()), 82, (Component)this.getBlacklistWhitelistText(((ExtractorAttachmentContainerMenu)this.menu).getBlacklistWhitelist()), btn -> this.setBlacklistWhitelist((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.menu).getBlacklistWhitelist().next())));
        this.blacklistWhitelistButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
        this.exactModeButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 78, this.topPos + 76, IconButtonPreset.NORMAL, this.getExactModeX(((ExtractorAttachmentContainerMenu)this.menu).isExactMode()), 103, (Component)this.getExactModeText(((ExtractorAttachmentContainerMenu)this.menu).isExactMode()), btn -> this.setExactMode((IconButton)btn, !((ExtractorAttachmentContainerMenu)this.menu).isExactMode())));
        this.exactModeButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getCanSetExactMode();
        if (!((ExtractorAttachmentContainerMenu)this.menu).isFluidMode()) {
            this.routingModeButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 101, this.topPos + 76, IconButtonPreset.NORMAL, this.getRoutingModeX(((ExtractorAttachmentContainerMenu)this.menu).getRoutingMode()), 194, (Component)this.getRoutingModeText(((ExtractorAttachmentContainerMenu)this.menu).getRoutingMode()), btn -> this.setRoutingMode((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.menu).getRoutingMode().next())));
            this.routingModeButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
            this.plusButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 125, this.topPos + 76 - 3, IconButtonPreset.SMALL, 198, 19, (Component)Component.literal((String)"+"), btn -> this.updateStackSize(1)));
            this.minusButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 125, this.topPos + 76 + 14 - 3, IconButtonPreset.SMALL, 198, 34, (Component)Component.literal((String)"-"), btn -> this.updateStackSize(-1)));
            this.minusButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getStackSize() > 0;
            this.plusButton.active = ((ExtractorAttachmentContainerMenu)this.menu).getStackSize() < ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getItemsToExtract();
        }
    }

    private void updateStackSize(int amount) {
        int newAmount;
        if (ExtractorAttachmentScreen.hasShiftDown()) {
            amount *= 4;
        }
        if ((newAmount = ((ExtractorAttachmentContainerMenu)this.menu).getStackSize() + amount) < 0) {
            newAmount = 0;
        }
        if (newAmount > ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getItemsToExtract()) {
            newAmount = ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getItemsToExtract();
        }
        this.minusButton.active = newAmount > 0;
        this.plusButton.active = newAmount < ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getItemsToExtract();
        ((ExtractorAttachmentContainerMenu)this.menu).setStackSize(newAmount);
    }

    private int getRedstoneModeX(RedstoneMode redstoneMode) {
        switch (redstoneMode) {
            case IGNORED: {
                return 219;
            }
            case HIGH: {
                return 177;
            }
            case LOW: {
                return 198;
            }
        }
        return 0;
    }

    private MutableComponent getRedstoneModeText(RedstoneMode redstoneMode) {
        return Component.translatable((String)("misc.fastpipes.redstone_mode." + redstoneMode.toString().toLowerCase()));
    }

    private void setRedstoneMode(IconButton button, RedstoneMode redstoneMode) {
        button.setMessage((Component)this.getRedstoneModeText(redstoneMode));
        button.setOverlayTexX(this.getRedstoneModeX(redstoneMode));
        ((ExtractorAttachmentContainerMenu)this.menu).setRedstoneMode(redstoneMode);
    }

    private int getBlacklistWhitelistX(BlacklistWhitelist blacklistWhitelist) {
        switch (blacklistWhitelist) {
            case BLACKLIST: {
                return 198;
            }
            case WHITELIST: {
                return 177;
            }
        }
        return 0;
    }

    private MutableComponent getBlacklistWhitelistText(BlacklistWhitelist blacklistWhitelist) {
        return Component.translatable((String)("misc.fastpipes.mode." + blacklistWhitelist.toString().toLowerCase()));
    }

    private void setBlacklistWhitelist(IconButton button, BlacklistWhitelist blacklistWhitelist) {
        button.setMessage((Component)this.getBlacklistWhitelistText(blacklistWhitelist));
        button.setOverlayTexX(this.getBlacklistWhitelistX(blacklistWhitelist));
        ((ExtractorAttachmentContainerMenu)this.menu).setBlacklistWhitelist(blacklistWhitelist);
    }

    private int getRoutingModeX(RoutingMode routingMode) {
        switch (routingMode) {
            case NEAREST: {
                return 0;
            }
            case FURTHEST: {
                return 21;
            }
            case RANDOM: {
                return 42;
            }
            case ROUND_ROBIN: {
                return 63;
            }
        }
        return 0;
    }

    private MutableComponent getRoutingModeText(RoutingMode routingMode) {
        return Component.translatable((String)("misc.fastpipes.routing_mode." + routingMode.toString().toLowerCase()));
    }

    private void setRoutingMode(IconButton button, RoutingMode routingMode) {
        button.setMessage((Component)this.getRoutingModeText(routingMode));
        button.setOverlayTexX(this.getRoutingModeX(routingMode));
        ((ExtractorAttachmentContainerMenu)this.menu).setRoutingMode(routingMode);
    }

    private int getExactModeX(boolean exactMode) {
        return exactMode ? 177 : 198;
    }

    private MutableComponent getExactModeText(boolean exactMode) {
        return Component.translatable((String)("misc.fastpipes.exact_mode." + (exactMode ? "on" : "off")));
    }

    private void setExactMode(IconButton button, boolean exactMode) {
        button.setMessage((Component)this.getExactModeText(exactMode));
        button.setOverlayTexX(this.getExactModeX(exactMode));
        ((ExtractorAttachmentContainerMenu)this.menu).setExactMode(exactMode);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        this.font.drawInBatch(this.title.getString(), 7.0f, 7.0f, 0x404040, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.font.drawInBatch(I18n.get((String)"container.inventory", (Object[])new Object[0]), 7.0f, 99.0f, 0x404040, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (!((ExtractorAttachmentContainerMenu)this.menu).isFluidMode()) {
            this.font.drawInBatch("" + ((ExtractorAttachmentContainerMenu)this.menu).getStackSize(), 143.0f, 83.0f, 0x404040, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        this.tooltip.clear();
        if (this.blacklistWhitelistButton.isHovered()) {
            this.tooltip.add((Component)Component.translatable((String)"misc.fastpipes.mode"));
            this.tooltip.add((Component)this.getBlacklistWhitelistText(((ExtractorAttachmentContainerMenu)this.menu).getBlacklistWhitelist()).withStyle(ChatFormatting.GRAY));
        } else if (this.redstoneModeButton.isHovered()) {
            this.tooltip.add((Component)Component.translatable((String)"misc.fastpipes.redstone_mode"));
            this.tooltip.add((Component)this.getRedstoneModeText(((ExtractorAttachmentContainerMenu)this.menu).getRedstoneMode()).withStyle(ChatFormatting.GRAY));
        } else if (this.routingModeButton != null && this.routingModeButton.isHovered()) {
            this.tooltip.add((Component)Component.translatable((String)"misc.fastpipes.routing_mode"));
            this.tooltip.add((Component)this.getRoutingModeText(((ExtractorAttachmentContainerMenu)this.menu).getRoutingMode()).withStyle(ChatFormatting.GRAY));
        } else if (this.exactModeButton.isHovered()) {
            this.tooltip.add((Component)Component.translatable((String)"misc.fastpipes.exact_mode"));
            this.tooltip.add((Component)this.getExactModeText(((ExtractorAttachmentContainerMenu)this.menu).isExactMode()).withStyle(ChatFormatting.GRAY));
        }
        if (!this.tooltip.isEmpty()) {
            graphics.renderComponentTooltip(this.font, this.tooltip, mouseX - this.leftPos, mouseY - this.topPos);
        }
        super.renderLabels(graphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(RESOURCE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int x = 43;
        int y = 18;
        for (int filterSlotId = 1; filterSlotId <= 15; ++filterSlotId) {
            if (filterSlotId > ((ExtractorAttachmentContainerMenu)this.menu).getExtractorAttachmentType().getFilterSlots()) {
                graphics.blit(RESOURCE, i + x, j + y, 198, 0, 18, 18);
            }
            if (filterSlotId % 5 == 0) {
                x = 43;
                y += 18;
                continue;
            }
            x += 18;
        }
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
    }
}

