/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.screen.widget;

import com.piglinmine.fastpipes.screen.widget.IconButtonPreset;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button {
    private static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"textures/gui/extractor_attachment.png");
    private final IconButtonPreset preset;
    private int overlayTexX;
    private int overlayTexY;

    public IconButton(int x, int y, IconButtonPreset preset, int overlayTexX, int overlayTexY, Component text, Button.OnPress onPress) {
        super(x, y, preset.getWidth(), preset.getHeight(), text, onPress, DEFAULT_NARRATION);
        this.preset = preset;
        this.overlayTexX = overlayTexX;
        this.overlayTexY = overlayTexY;
    }

    public void setOverlayTexX(int overlayTexX) {
        this.overlayTexX = overlayTexX;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int y = this.preset.getYTexNormal();
        if (!this.active) {
            y = this.preset.getYTexDisabled();
        } else if (this.isHovered) {
            y = this.preset.getYTexHover();
        }
        graphics.blit(RESOURCE, this.getX(), this.getY(), (float)this.preset.getXTex(), (float)y, this.width, this.height, 256, 256);
        graphics.blit(RESOURCE, this.getX() + 1, this.getY() + 1, (float)(this.overlayTexX + 1), (float)(this.overlayTexY + 1), this.width - 2, this.height - 2, 256, 256);
    }
}

