/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.setup;

import com.piglinmine.fastpipes.FPipesBlockEntities;
import com.piglinmine.fastpipes.FPipesBlocks;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentRegistry;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipeType;
import com.piglinmine.fastpipes.render.FluidPipeBlockEntityRenderer;
import com.piglinmine.fastpipes.render.ItemPipeBlockEntityRenderer;
import com.piglinmine.fastpipes.render.PipeBakedModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientSetup {
    private static final Logger LOGGER = LogManager.getLogger(ClientSetup.class);

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.BASIC_ITEM_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.IMPROVED_ITEM_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ADVANCED_ITEM_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.BASIC_FLUID_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.IMPROVED_FLUID_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ADVANCED_FLUID_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ELITE_FLUID_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ULTIMATE_FLUID_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.BASIC_ENERGY_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.IMPROVED_ENERGY_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ADVANCED_ENERGY_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ELITE_ENERGY_PIPE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FPipesBlocks.ULTIMATE_ENERGY_PIPE.get()), (RenderType)RenderType.cutout());
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.BASIC_ITEM_PIPE.get()), ItemPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.IMPROVED_ITEM_PIPE.get()), ItemPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.ADVANCED_ITEM_PIPE.get()), ItemPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.BASIC_FLUID_PIPE.get()), FluidPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.IMPROVED_FLUID_PIPE.get()), FluidPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.ADVANCED_FLUID_PIPE.get()), FluidPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.ELITE_FLUID_PIPE.get()), FluidPipeBlockEntityRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FPipesBlockEntities.ULTIMATE_FLUID_PIPE.get()), FluidPipeBlockEntityRenderer::new);
        });
    }

    @SubscribeEvent
    public static void registerSpecialModels(ModelEvent.RegisterAdditional event) {
        LOGGER.debug("Registering special models for Fast Pipes");
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            LOGGER.debug("Registering attachment model {}", (Object)factory.getModelLocation());
            event.register(ModelResourceLocation.standalone((ResourceLocation)factory.getModelLocation()));
        }
        for (String type : new String[]{"item", "fluid", "energy"}) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/basic/core"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/basic/extension"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/basic/straight"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/improved/core"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/improved/extension"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/improved/straight"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/advanced/core"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/advanced/extension"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/advanced/straight"))));
            if (!type.equals("fluid") && !type.equals("energy")) continue;
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/elite/core"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/elite/extension"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/elite/straight"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/ultimate/core"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/ultimate/extension"))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/ultimate/straight"))));
        }
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/inventory_attachment")));
        LOGGER.debug("Special models registered successfully");
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        LOGGER.debug("Modifying baking result for Fast Pipes");
        HashMap<ResourceLocation, BakedModel> attachmentModels = new HashMap<ResourceLocation, BakedModel>();
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            BakedModel model = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)factory.getModelLocation()));
            if (model != null) {
                attachmentModels.put(factory.getId(), model);
                LOGGER.debug("Collected attachment model for {}", (Object)factory.getId());
                continue;
            }
            LOGGER.warn("Failed to find attachment model for {}", (Object)factory.getModelLocation());
        }
        HashMap<ResourceLocation, PipeBakedModel> pipeModels = new HashMap<ResourceLocation, PipeBakedModel>();
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, ItemPipeType.BASIC.getId(), "item", "basic");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, ItemPipeType.IMPROVED.getId(), "item", "improved");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, ItemPipeType.ADVANCED.getId(), "item", "advanced");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, FluidPipeType.BASIC.getId(), "fluid", "basic");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, FluidPipeType.IMPROVED.getId(), "fluid", "improved");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, FluidPipeType.ADVANCED.getId(), "fluid", "advanced");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, FluidPipeType.ELITE.getId(), "fluid", "elite");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, FluidPipeType.ULTIMATE.getId(), "fluid", "ultimate");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, EnergyPipeType.BASIC.getId(), "energy", "basic");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, EnergyPipeType.IMPROVED.getId(), "energy", "improved");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, EnergyPipeType.ADVANCED.getId(), "energy", "advanced");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, EnergyPipeType.ELITE.getId(), "energy", "elite");
        ClientSetup.createPipeBakedModel(event, pipeModels, attachmentModels, EnergyPipeType.ULTIMATE.getId(), "energy", "ultimate");
        int replacedModels = 0;
        for (ModelResourceLocation id : event.getModels().keySet()) {
            for (Map.Entry entry : pipeModels.entrySet()) {
                if (!ClientSetup.isPipeModel(id, (ResourceLocation)entry.getKey())) continue;
                event.getModels().put(id, (BakedModel)entry.getValue());
                ++replacedModels;
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("Replaced pipe model for {}", (Object)id);
            }
        }
        LOGGER.info("Model baking modification completed - replaced {} pipe model variants", (Object)replacedModels);
    }

    private static void createPipeBakedModel(ModelEvent.ModifyBakingResult event, Map<ResourceLocation, PipeBakedModel> pipeModels, Map<ResourceLocation, BakedModel> attachmentModels, ResourceLocation pipeId, String type, String tier) {
        BakedModel core = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/" + tier + "/core"))));
        BakedModel extension = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/" + tier + "/extension"))));
        BakedModel straight = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)("block/pipe/" + type + "/" + tier + "/straight"))));
        BakedModel inventoryAttachment = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fastpipes", (String)"block/pipe/attachment/inventory_attachment")));
        if (core != null && extension != null && straight != null && inventoryAttachment != null) {
            pipeModels.put(pipeId, new PipeBakedModel(core, extension, straight, inventoryAttachment, attachmentModels));
            LOGGER.trace("Created PipeBakedModel for {} {} {}", (Object)type, (Object)tier, (Object)pipeId);
        } else {
            LOGGER.warn("Failed to create PipeBakedModel for {} {} {} - missing models: core={}, extension={}, straight={}, inventoryAttachment={}", (Object)type, (Object)tier, (Object)pipeId, (Object)(core != null ? 1 : 0), (Object)(extension != null ? 1 : 0), (Object)(straight != null ? 1 : 0), (Object)(inventoryAttachment != null ? 1 : 0));
        }
    }

    private static boolean isPipeModel(ModelResourceLocation modelId, ResourceLocation pipeId) {
        return modelId.id().getNamespace().equals("fastpipes") && modelId.id().getPath().equals(pipeId.getPath()) && !modelId.variant().equals("inventory");
    }
}

