/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.setup;

import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.NetworkRegistry;
import com.piglinmine.fastpipes.network.energy.EnergyNetworkFactory;
import com.piglinmine.fastpipes.network.fluid.FluidNetworkFactory;
import com.piglinmine.fastpipes.network.item.ItemNetwork;
import com.piglinmine.fastpipes.network.item.ItemNetworkFactory;
import com.piglinmine.fastpipes.network.pipe.PipeRegistry;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentRegistry;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeFactory;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipe;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeFactory;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipe;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipeFactory;
import com.piglinmine.fastpipes.network.pipe.transport.callback.TransportCallbackFactoryRegistry;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonSetup {
    private static final Logger LOGGER = LogManager.getLogger(CommonSetup.class);

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent event) {
        LOGGER.debug("Constructing Fast Pipes mod");
        TransportCallbackFactoryRegistry.INSTANCE.initialize(null);
        CommonSetup.registerNetworkFactories();
        CommonSetup.registerPipeFactories();
        CommonSetup.registerAttachmentFactories();
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.debug("Common setup for Fast Pipes");
    }

    private static void registerNetworkFactories() {
        LOGGER.debug("Registering network factories");
        NetworkRegistry.INSTANCE.addFactory(ItemNetwork.TYPE, new ItemNetworkFactory());
        LOGGER.debug("Registered ItemNetworkFactory for type: {}", (Object)ItemNetwork.TYPE);
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            NetworkRegistry.INSTANCE.addFactory(fluidPipeType.getNetworkType(), new FluidNetworkFactory(fluidPipeType));
            LOGGER.debug("Registered FluidNetworkFactory for type: {}", (Object)fluidPipeType.getNetworkType());
        }
        for (Enum enum_ : EnergyPipeType.values()) {
            NetworkRegistry.INSTANCE.addFactory(((EnergyPipeType)enum_).getNetworkType(), new EnergyNetworkFactory((EnergyPipeType)enum_));
            LOGGER.debug("Registered EnergyNetworkFactory for type: {}", (Object)((EnergyPipeType)enum_).getNetworkType());
        }
        LOGGER.debug("Network factories registered successfully");
    }

    private static void registerPipeFactories() {
        LOGGER.debug("Registering pipe factories");
        PipeRegistry.INSTANCE.addFactory(ItemPipe.ID, new ItemPipeFactory());
        LOGGER.debug("Registered ItemPipeFactory for ID: {}", (Object)ItemPipe.ID);
        PipeRegistry.INSTANCE.addFactory(FluidPipe.ID, new FluidPipeFactory());
        LOGGER.debug("Registered FluidPipeFactory for ID: {}", (Object)FluidPipe.ID);
        PipeRegistry.INSTANCE.addFactory(EnergyPipe.ID, new EnergyPipeFactory());
        LOGGER.debug("Registered EnergyPipeFactory for ID: {}", (Object)EnergyPipe.ID);
        LOGGER.debug("Pipe factories registered successfully");
    }

    private static void registerAttachmentFactories() {
        LOGGER.debug("Registering attachment factories");
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.BASIC.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.BASIC));
        LOGGER.debug("Registered ExtractorAttachmentFactory for type: {}", (Object)ExtractorAttachmentType.BASIC.getId());
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.IMPROVED.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.IMPROVED));
        LOGGER.debug("Registered ExtractorAttachmentFactory for type: {}", (Object)ExtractorAttachmentType.IMPROVED.getId());
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ADVANCED.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ADVANCED));
        LOGGER.debug("Registered ExtractorAttachmentFactory for type: {}", (Object)ExtractorAttachmentType.ADVANCED.getId());
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ELITE.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ELITE));
        LOGGER.debug("Registered ExtractorAttachmentFactory for type: {}", (Object)ExtractorAttachmentType.ELITE.getId());
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ULTIMATE.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ULTIMATE));
        LOGGER.debug("Registered ExtractorAttachmentFactory for type: {}", (Object)ExtractorAttachmentType.ULTIMATE.getId());
        LOGGER.debug("Attachment factories registered successfully");
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide()) {
            NetworkManager.get(event.getLevel()).getNetworks().forEach(n -> n.update(event.getLevel()));
        }
    }
}

