/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.util;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class Raytracer {
    public static Pair<Vec3, Vec3> getVectors(Entity entity) {
        float pitch = entity.getXRot();
        float yaw = entity.getYRot();
        Vec3 start = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        float f1 = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            d3 = serverPlayer.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        }
        Vec3 end = start.add((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    public static AdvancedRayTraceResult<BlockHitResult> collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, Collection<AABB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult<BlockHitResult> hit = null;
        int i = -1;
        for (AABB aabb : boxes) {
            double d;
            AdvancedRayTraceResult<BlockHitResult> result;
            AdvancedRayTraceResult<BlockHitResult> advancedRayTraceResult = result = aabb == null ? null : Raytracer.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult<BlockHitResult> collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, AABB bounds, int subHit, Object hitInfo) {
        BlockHitResult result = AABB.clip(Collections.singleton(bounds), (Vec3)start, (Vec3)end, (BlockPos)pos);
        if (result == null) {
            return null;
        }
        return new AdvancedRayTraceResult<BlockHitResult>(result, bounds);
    }

    public static boolean inclusiveContains(AABB aabb, Vec3 hit) {
        return hit.x >= aabb.minX && hit.x <= aabb.maxX && hit.y >= aabb.minY && hit.y <= aabb.maxY && hit.z >= aabb.minZ && hit.z <= aabb.maxZ;
    }

    public static class AdvancedRayTraceResult<T extends HitResult> {
        public final AABB bounds;
        public final T hit;

        public AdvancedRayTraceResult(T mop, AABB aabb) {
            this.hit = mop;
            this.bounds = aabb;
        }

        public double squareDistanceTo(Vec3 vec) {
            return this.hit.getLocation().distanceToSqr(vec);
        }
    }
}

