/*
 * Decompiled with CFR 0.152.
 */
package com.itempositioner.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.itempositioner.ItemPositionerClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class SlotAssignmentManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    private final Map<String, Integer> assignments = new HashMap<String, Integer>();

    public SlotAssignmentManager() {
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve("itempositioner_slots.json");
    }

    public void assignSlot(class_1792 item, int slot) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        String existingItem = this.getItemAtSlot(slot);
        if (existingItem != null && !existingItem.equals(itemId)) {
            this.assignments.remove(existingItem);
        }
        this.assignments.put(itemId, slot);
        this.save();
    }

    public void removeAssignment(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        this.assignments.remove(itemId);
        this.save();
    }

    public void removeAssignmentBySlot(int slot) {
        String itemToRemove = null;
        for (Map.Entry<String, Integer> entry : this.assignments.entrySet()) {
            if (entry.getValue() != slot) continue;
            itemToRemove = entry.getKey();
            break;
        }
        if (itemToRemove != null) {
            this.assignments.remove(itemToRemove);
            this.save();
        }
    }

    public Integer getAssignedSlot(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return this.assignments.get(itemId);
    }

    public String getItemAtSlot(int slot) {
        for (Map.Entry<String, Integer> entry : this.assignments.entrySet()) {
            if (entry.getValue() != slot) continue;
            return entry.getKey();
        }
        return null;
    }

    public class_1792 getItemObjectAtSlot(int slot) {
        String itemId = this.getItemAtSlot(slot);
        if (itemId != null) {
            return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
        }
        return null;
    }

    public Map<String, Integer> getAllAssignments() {
        return Collections.unmodifiableMap(this.assignments);
    }

    public boolean hasAssignment(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return this.assignments.containsKey(itemId);
    }

    public boolean isSlotAssigned(int slot) {
        return this.assignments.containsValue(slot);
    }

    public void clearAll() {
        this.assignments.clear();
        this.save();
    }

    public void load() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
                Type type = new TypeToken<Map<String, Integer>>(this){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.assignments.clear();
                    this.assignments.putAll(loaded);
                }
                ItemPositionerClient.LOGGER.info("Loaded {} slot assignments", (Object)this.assignments.size());
            }
            catch (Exception e) {
                ItemPositionerClient.LOGGER.error("Failed to load slot assignments", (Throwable)e);
            }
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                GSON.toJson(this.assignments, (Appendable)writer);
            }
            ItemPositionerClient.LOGGER.info("Saved {} slot assignments", (Object)this.assignments.size());
        }
        catch (Exception e) {
            ItemPositionerClient.LOGGER.error("Failed to save slot assignments", (Throwable)e);
        }
    }
}

