/*
 * Decompiled with CFR 0.152.
 */
package com.itempositioner.gui;

import com.itempositioner.ItemPositionerClient;
import com.itempositioner.config.SlotAssignmentManager;
import com.itempositioner.util.InventorySorter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemPositionerScreen
extends class_437 {
    private static final int SLOT_SIZE = 18;
    private static final int ITEM_BROWSER_WIDTH = 162;
    private static final int ITEM_BROWSER_HEIGHT = 180;
    private static final int ITEMS_PER_ROW = 9;
    private final List<class_1792> allItems = new ArrayList<class_1792>();
    private final List<class_1792> filteredItems = new ArrayList<class_1792>();
    private class_1792 draggedItem = null;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int browserX;
    private int browserY;
    private int inventoryX;
    private int inventoryY;
    private class_342 searchField;
    private boolean isDraggingScrollbar = false;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarWidth;
    private int scrollbarHeight;

    public ItemPositionerScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.itempositioner.title"));
        this.loadAllItems();
    }

    private void loadAllItems() {
        this.allItems.clear();
        for (class_1792 item2 : class_7923.field_41178) {
            if (item2 == class_1802.field_8162) continue;
            this.allItems.add(item2);
        }
        this.allItems.sort(Comparator.comparing(item -> class_7923.field_41178.method_10221(item).toString()));
        this.filteredItems.clear();
        this.filteredItems.addAll(this.allItems);
        this.updateScrollOffset();
    }

    private void updateScrollOffset() {
        int totalRows = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
        int visibleRows = 10;
        this.maxScrollOffset = Math.max(0, totalRows - visibleRows);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
    }

    private void filterItems(String query) {
        this.filteredItems.clear();
        if (query == null || query.isEmpty()) {
            this.filteredItems.addAll(this.allItems);
        } else {
            Pattern pattern;
            String lowerQuery = query.toLowerCase();
            String regex = lowerQuery.replace("*", ".*").replace("?", ".");
            try {
                pattern = Pattern.compile(regex);
            }
            catch (Exception e) {
                pattern = Pattern.compile(Pattern.quote(lowerQuery));
            }
            for (class_1792 item : this.allItems) {
                String itemName = new class_1799((class_1935)item).method_7964().getString().toLowerCase();
                String itemId = class_7923.field_41178.method_10221((Object)item).toString().toLowerCase();
                if (!pattern.matcher(itemName).find() && !pattern.matcher(itemId).find()) continue;
                this.filteredItems.add(item);
            }
        }
        this.scrollOffset = 0;
        this.updateScrollOffset();
    }

    protected void method_25426() {
        this.browserX = this.field_22789 / 2 - 162 - 30;
        this.browserY = (this.field_22790 - 180) / 2 + 15;
        this.inventoryX = this.field_22789 / 2 + 20;
        this.inventoryY = (this.field_22790 - 76) / 2;
        this.scrollbarX = this.browserX + 162 + 2;
        this.scrollbarY = this.browserY;
        this.scrollbarWidth = 8;
        this.scrollbarHeight = 180;
        this.searchField = new class_342(this.field_22793, this.browserX, this.browserY - 22, 162, 18, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search items... (* = wildcard)").method_27692(class_124.field_1080));
        this.searchField.method_1863(this::filterItems);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All"), button -> ItemPositionerClient.getSlotManager().clearAll()).method_46434(this.inventoryX, this.inventoryY + 72 + 15, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sort Items"), button -> InventorySorter.sortInventory()).method_46434(this.inventoryX + 85, this.inventoryY + 72 + 15, 80, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE, Integer.MIN_VALUE);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Items").method_27692(class_124.field_1054), this.browserX, this.browserY - 35, 0xFFFFFF);
        this.renderItemBrowser(context, mouseX, mouseY);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Inventory Slots").method_27692(class_124.field_1054), this.inventoryX, this.inventoryY - 12, 0xFFFFFF);
        this.renderInventorySlots(context, mouseX, mouseY);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Drag items to assign slots").method_27692(class_124.field_1080), this.field_22789 / 2 - 60, this.browserY + 180 + 10, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Right-click slot to clear").method_27692(class_124.field_1080), this.field_22789 / 2 - 55, this.browserY + 180 + 22, 0xAAAAAA);
        if (this.draggedItem != null) {
            context.method_51427(new class_1799((class_1935)this.draggedItem), mouseX - 8, mouseY - 8);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderItemBrowser(class_332 context, int mouseX, int mouseY) {
        context.method_25294(this.browserX - 2, this.browserY - 2, this.browserX + 162 + 2, this.browserY + 180 + 2, -13158601);
        context.method_25294(this.browserX, this.browserY, this.browserX + 162, this.browserY + 180, -7631989);
        int visibleRows = 10;
        int startIndex = this.scrollOffset * 9;
        for (int row = 0; row < visibleRows; ++row) {
            int index;
            for (int col = 0; col < 9 && (index = startIndex + row * 9 + col) < this.filteredItems.size(); ++col) {
                int slotX = this.browserX + col * 18;
                int slotY = this.browserY + row * 18;
                context.method_25294(slotX, slotY, slotX + 18 - 1, slotY + 18 - 1, -7631989);
                context.method_49601(slotX, slotY, 17, 17, -13158601);
                class_1792 item = this.filteredItems.get(index);
                context.method_51427(new class_1799((class_1935)item), slotX + 1, slotY + 1);
                if (mouseX < slotX || mouseX >= slotX + 18 || mouseY < slotY || mouseY >= slotY + 18) continue;
                context.method_25294(slotX, slotY, slotX + 18 - 1, slotY + 18 - 1, -2130706433);
                context.method_51438(this.field_22793, new class_1799((class_1935)item).method_7964(), mouseX, mouseY);
            }
        }
        if (this.maxScrollOffset > 0) {
            context.method_25294(this.scrollbarX, this.scrollbarY, this.scrollbarX + this.scrollbarWidth, this.scrollbarY + this.scrollbarHeight, -11184811);
            int thumbHeight = Math.max(20, this.scrollbarHeight * visibleRows / (this.maxScrollOffset + visibleRows));
            int thumbY = this.scrollbarY + (int)((double)(this.scrollbarHeight - thumbHeight) * ((double)this.scrollOffset / (double)this.maxScrollOffset));
            boolean hoveringThumb = mouseX >= this.scrollbarX && mouseX < this.scrollbarX + this.scrollbarWidth && mouseY >= thumbY && mouseY < thumbY + thumbHeight;
            int thumbColor = hoveringThumb || this.isDraggingScrollbar ? -3355444 : -5592406;
            context.method_25294(this.scrollbarX + 1, thumbY, this.scrollbarX + this.scrollbarWidth - 1, thumbY + thumbHeight, thumbColor);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)(this.filteredItems.size() + " items")).method_27692(class_124.field_1063), this.browserX, this.browserY + 180 + 3, 0x808080);
    }

    private void renderInventorySlots(class_332 context, int mouseX, int mouseY) {
        SlotAssignmentManager manager = ItemPositionerClient.getSlotManager();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = 9 + row * 9 + col;
                int slotX = this.inventoryX + col * 18;
                int slotY = this.inventoryY + row * 18;
                this.renderSlot(context, slotX, slotY, slot, manager, mouseX, mouseY);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int slot = col;
            int slotX = this.inventoryX + col * 18;
            int slotY = this.inventoryY + 54 + 4;
            this.renderSlot(context, slotX, slotY, slot, manager, mouseX, mouseY);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Hotbar").method_27692(class_124.field_1075), this.inventoryX, this.inventoryY + 54 + 4 + 18 + 2, 0xAAAAAA);
    }

    private void renderSlot(class_332 context, int slotX, int slotY, int slot, SlotAssignmentManager manager, int mouseX, int mouseY) {
        class_1792 assignedItem;
        boolean isAssigned = manager.isSlotAssigned(slot);
        int bgColor = isAssigned ? -11896246 : -7631989;
        context.method_25294(slotX, slotY, slotX + 18 - 1, slotY + 18 - 1, bgColor);
        context.method_49601(slotX, slotY, 17, 17, -13158601);
        if (isAssigned && (assignedItem = manager.getItemObjectAtSlot(slot)) != null) {
            context.method_51427(new class_1799((class_1935)assignedItem), slotX + 1, slotY + 1);
        }
        String slotNum = String.valueOf(slot);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)slotNum).method_27692(class_124.field_1063), slotX + 2, slotY + 2, 0x404040);
        if (mouseX >= slotX && mouseX < slotX + 18 && mouseY >= slotY && mouseY < slotY + 18) {
            context.method_25294(slotX, slotY, slotX + 18 - 1, slotY + 18 - 1, 0x40FFFFFF);
            if (isAssigned) {
                class_1792 item = manager.getItemObjectAtSlot(slot);
                if (item != null) {
                    context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("Slot " + slot + ": ")).method_10852(new class_1799((class_1935)item).method_7964()), mouseX, mouseY);
                }
            } else {
                context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("Slot " + slot + " (empty)")), mouseX, mouseY);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int slot;
        if (button == 0 && this.maxScrollOffset > 0 && mouseX >= (double)this.scrollbarX && mouseX < (double)(this.scrollbarX + this.scrollbarWidth) && mouseY >= (double)this.scrollbarY && mouseY < (double)(this.scrollbarY + this.scrollbarHeight)) {
            this.isDraggingScrollbar = true;
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        if (button == 0) {
            class_1792 clickedItem = this.getItemAtBrowserPosition((int)mouseX, (int)mouseY);
            if (clickedItem != null) {
                this.draggedItem = clickedItem;
                return true;
            }
        } else if (button == 1 && (slot = this.getInventorySlotAt((int)mouseX, (int)mouseY)) != -1) {
            ItemPositionerClient.getSlotManager().removeAssignmentBySlot(slot);
            this.playClickSound();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        if (button == 0 && this.draggedItem != null) {
            int slot = this.getInventorySlotAt((int)mouseX, (int)mouseY);
            if (slot != -1) {
                ItemPositionerClient.getSlotManager().assignSlot(this.draggedItem, slot);
                this.playClickSound();
            }
            this.draggedItem = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isDraggingScrollbar) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateScrollFromMouse(double mouseY) {
        if (this.maxScrollOffset <= 0) {
            return;
        }
        double relativeY = mouseY - (double)this.scrollbarY;
        double ratio = Math.max(0.0, Math.min(1.0, relativeY / (double)this.scrollbarHeight));
        this.scrollOffset = (int)Math.round(ratio * (double)this.maxScrollOffset);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.browserX && mouseX < (double)(this.browserX + 162 + this.scrollbarWidth + 5) && mouseY >= (double)this.browserY && mouseY < (double)(this.browserY + 180)) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)verticalAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private class_1792 getItemAtBrowserPosition(int mouseX, int mouseY) {
        if (mouseX < this.browserX || mouseX >= this.browserX + 162 || mouseY < this.browserY || mouseY >= this.browserY + 180) {
            return null;
        }
        int row = (mouseY - this.browserY) / 18;
        int col = (mouseX - this.browserX) / 18;
        int index = (this.scrollOffset + row) * 9 + col;
        if (index >= 0 && index < this.filteredItems.size()) {
            return this.filteredItems.get(index);
        }
        return null;
    }

    private int getInventorySlotAt(int mouseX, int mouseY) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = this.inventoryX + col * 18;
                int slotY = this.inventoryY + row * 18;
                if (mouseX < slotX || mouseX >= slotX + 18 || mouseY < slotY || mouseY >= slotY + 18) continue;
                return 9 + row * 9 + col;
            }
        }
        for (int col = 0; col < 9; ++col) {
            int slotX = this.inventoryX + col * 18;
            int slotY = this.inventoryY + 54 + 4;
            if (mouseX < slotX || mouseX >= slotX + 18 || mouseY < slotY || mouseY >= slotY + 18) continue;
            return col;
        }
        return -1;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void playClickSound() {
        if (this.field_22787 != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }
}

