/*
 * Decompiled with CFR 0.152.
 */
package com.itempositioner.mixin;

import com.itempositioner.ItemPositionerClient;
import com.itempositioner.config.SlotAssignmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1661.class})
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public class_2371<class_1799> field_7547;

    @Inject(method={"insertStack(ILnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInsertStack(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_7960()) {
            return;
        }
        if (slot != -1) {
            return;
        }
        SlotAssignmentManager manager = ItemPositionerClient.getSlotManager();
        if (manager == null) {
            return;
        }
        class_1792 item = stack.method_7909();
        Integer assignedSlot = manager.getAssignedSlot(item);
        if (assignedSlot != null) {
            int nearestFree;
            class_1661 inventory = (class_1661)this;
            int originalCount = stack.method_7947();
            this.displaceItemIfNeeded(inventory, assignedSlot, manager);
            this.tryInsertAtSlot(inventory, stack, assignedSlot);
            if (!stack.method_7960() && (nearestFree = this.findNearestFreeSlot(inventory, assignedSlot)) != -1) {
                this.tryInsertAtSlot(inventory, stack, nearestFree);
            }
            if (stack.method_7947() < originalCount && stack.method_7960()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"insertStack(Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddStack(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_7960()) {
            return;
        }
        SlotAssignmentManager manager = ItemPositionerClient.getSlotManager();
        if (manager == null) {
            return;
        }
        class_1792 item = stack.method_7909();
        Integer assignedSlot = manager.getAssignedSlot(item);
        if (assignedSlot != null) {
            int nearestFree;
            class_1661 inventory = (class_1661)this;
            int originalCount = stack.method_7947();
            this.displaceItemIfNeeded(inventory, assignedSlot, manager);
            this.tryInsertAtSlot(inventory, stack, assignedSlot);
            if (!stack.method_7960() && (nearestFree = this.findNearestFreeSlot(inventory, assignedSlot)) != -1) {
                this.tryInsertAtSlot(inventory, stack, nearestFree);
            }
            if (stack.method_7947() < originalCount && stack.method_7960()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    private void displaceItemIfNeeded(class_1661 inventory, int targetSlot, SlotAssignmentManager manager) {
        int freeSlot;
        if (targetSlot < 0 || targetSlot >= this.field_7547.size()) {
            return;
        }
        class_1799 existing = (class_1799)this.field_7547.get(targetSlot);
        if (existing.method_7960()) {
            return;
        }
        class_1792 existingItem = existing.method_7909();
        Integer existingAssignedSlot = manager.getAssignedSlot(existingItem);
        if ((existingAssignedSlot == null || existingAssignedSlot != targetSlot) && (freeSlot = this.findNearestFreeSlot(inventory, targetSlot)) != -1) {
            this.field_7547.set(freeSlot, (Object)existing.method_7972());
            this.field_7547.set(targetSlot, (Object)class_1799.field_8037);
        }
    }

    private void tryInsertAtSlot(class_1661 inventory, class_1799 stack, int slot) {
        int maxCount;
        int canAdd;
        int toAdd;
        if (slot < 0 || slot >= this.field_7547.size()) {
            return;
        }
        class_1799 existing = (class_1799)this.field_7547.get(slot);
        if (existing.method_7960()) {
            this.field_7547.set(slot, (Object)stack.method_7972());
            stack.method_7939(0);
            return;
        }
        if (class_1799.method_31577((class_1799)existing, (class_1799)stack) && (toAdd = Math.min(canAdd = (maxCount = existing.method_7914()) - existing.method_7947(), stack.method_7947())) > 0) {
            existing.method_7933(toAdd);
            stack.method_7934(toAdd);
        }
    }

    private int findNearestFreeSlot(class_1661 inventory, int preferredSlot) {
        for (int offset = 1; offset < this.field_7547.size(); ++offset) {
            int slotPlus = (preferredSlot + offset) % this.field_7547.size();
            if (((class_1799)this.field_7547.get(slotPlus)).method_7960()) {
                return slotPlus;
            }
            int slotMinus = (preferredSlot - offset + this.field_7547.size()) % this.field_7547.size();
            if (slotMinus == slotPlus || !((class_1799)this.field_7547.get(slotMinus)).method_7960()) continue;
            return slotMinus;
        }
        return -1;
    }
}

