/*
 * Decompiled with CFR 0.152.
 */
package com.itempositioner.util;

import com.itempositioner.ItemPositionerClient;
import com.itempositioner.config.SlotAssignmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3417;

@Environment(value=EnvType.CLIENT)
public class InventorySorter {
    public static void sortInventory() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1761 == null) {
            return;
        }
        SlotAssignmentManager manager = ItemPositionerClient.getSlotManager();
        if (manager == null) {
            return;
        }
        class_1703 currentHandler = client.field_1724.field_7512;
        class_1723 playerHandler = client.field_1724.field_7498;
        if (currentHandler != playerHandler) {
            ItemPositionerClient.LOGGER.warn("Cannot sort: a container screen is open");
            return;
        }
        int syncId = playerHandler.field_7763;
        if (!InventorySorter.clearCursorIfNeeded(client, playerHandler, syncId)) {
            ItemPositionerClient.LOGGER.warn("Cannot sort: failed to clear cursor");
            return;
        }
        class_1661 inv = client.field_1724.method_31548();
        int itemsMoved = 0;
        block0: for (int targetSlot = 0; targetSlot < 36; ++targetSlot) {
            class_1792 assignedItem;
            if (!manager.isSlotAssigned(targetSlot) || (assignedItem = manager.getItemObjectAtSlot(targetSlot)) == null) continue;
            class_1799 targetStack = inv.method_5438(targetSlot);
            if (!targetStack.method_7960() && targetStack.method_7909() != assignedItem) {
                int emptySlot = InventorySorter.findEmptySlotExcluding(inv, manager);
                if (emptySlot == -1) continue;
                if (!InventorySorter.moveSlotToSlot(client, playerHandler, syncId, targetSlot, emptySlot)) {
                    ItemPositionerClient.LOGGER.warn("Sort interrupted: failed to displace item from slot {}", (Object)targetSlot);
                    InventorySorter.clearCursorIfNeeded(client, playerHandler, syncId);
                    return;
                }
                ++itemsMoved;
            }
            boolean continueStacking = true;
            block1: while (continueStacking) {
                int currentCount;
                continueStacking = false;
                targetStack = inv.method_5438(targetSlot);
                int maxCount = targetStack.method_7960() ? assignedItem.method_7854().method_7914() : targetStack.method_7914();
                int n = currentCount = targetStack.method_7960() ? 0 : targetStack.method_7947();
                if (currentCount >= maxCount) continue block0;
                for (int sourceSlot = 0; sourceSlot < 36; ++sourceSlot) {
                    class_1799 sourceStack;
                    if (sourceSlot == targetSlot || (sourceStack = inv.method_5438(sourceSlot)).method_7960() || sourceStack.method_7909() != assignedItem) continue;
                    if (!InventorySorter.stackItemsToSlot(client, playerHandler, syncId, sourceSlot, targetSlot)) {
                        ItemPositionerClient.LOGGER.warn("Sort interrupted: stack failed");
                        InventorySorter.clearCursorIfNeeded(client, playerHandler, syncId);
                        return;
                    }
                    ++itemsMoved;
                    targetStack = inv.method_5438(targetSlot);
                    currentCount = targetStack.method_7960() ? 0 : targetStack.method_7947();
                    if (currentCount >= maxCount) continue block1;
                    sourceStack = inv.method_5438(sourceSlot);
                    if (sourceStack.method_7960() || sourceStack.method_7909() != assignedItem) continue;
                    continueStacking = true;
                }
            }
        }
        InventorySorter.clearCursorIfNeeded(client, playerHandler, syncId);
        if (itemsMoved > 0) {
            ItemPositionerClient.LOGGER.info("Sorted {} item operation(s) to assigned slots", (Object)itemsMoved);
            client.field_1724.method_5783(class_3417.field_14627, 0.5f, 1.2f);
        }
    }

    private static boolean clearCursorIfNeeded(class_310 client, class_1723 handler, int syncId) {
        class_1799 cursorStack = handler.method_34255();
        if (cursorStack.method_7960()) {
            return true;
        }
        int emptySlot = InventorySorter.findEmptySlot(client.field_1724.method_31548());
        if (emptySlot == -1) {
            return false;
        }
        int screenSlot = InventorySorter.playerSlotToScreenSlot(emptySlot);
        client.field_1761.method_2906(syncId, screenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        return handler.method_34255().method_7960();
    }

    private static boolean moveSlotToSlot(class_310 client, class_1723 handler, int syncId, int sourceSlot, int targetSlot) {
        int sourceScreenSlot = InventorySorter.playerSlotToScreenSlot(sourceSlot);
        int targetScreenSlot = InventorySorter.playerSlotToScreenSlot(targetSlot);
        client.field_1761.method_2906(syncId, sourceScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        if (handler.method_34255().method_7960()) {
            return false;
        }
        client.field_1761.method_2906(syncId, targetScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        return handler.method_34255().method_7960();
    }

    private static boolean stackItemsToSlot(class_310 client, class_1723 handler, int syncId, int sourceSlot, int targetSlot) {
        int sourceScreenSlot = InventorySorter.playerSlotToScreenSlot(sourceSlot);
        int targetScreenSlot = InventorySorter.playerSlotToScreenSlot(targetSlot);
        client.field_1761.method_2906(syncId, sourceScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        if (handler.method_34255().method_7960()) {
            return true;
        }
        client.field_1761.method_2906(syncId, targetScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        if (!handler.method_34255().method_7960()) {
            int emptySlot;
            client.field_1761.method_2906(syncId, sourceScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
            if (!handler.method_34255().method_7960() && (emptySlot = InventorySorter.findEmptySlot(client.field_1724.method_31548())) != -1) {
                int emptyScreenSlot = InventorySorter.playerSlotToScreenSlot(emptySlot);
                client.field_1761.method_2906(syncId, emptyScreenSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
            }
        }
        return handler.method_34255().method_7960();
    }

    private static int findEmptySlot(class_1661 inv) {
        int i;
        for (i = 9; i < 36; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            return i;
        }
        for (i = 0; i < 9; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private static int findEmptySlotExcluding(class_1661 inv, SlotAssignmentManager manager) {
        int i;
        for (i = 9; i < 36; ++i) {
            if (!inv.method_5438(i).method_7960() || manager.isSlotAssigned(i)) continue;
            return i;
        }
        for (i = 0; i < 9; ++i) {
            if (!inv.method_5438(i).method_7960() || manager.isSlotAssigned(i)) continue;
            return i;
        }
        for (i = 9; i < 36; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            return i;
        }
        for (i = 0; i < 9; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private static int playerSlotToScreenSlot(int playerSlot) {
        if (playerSlot < 9) {
            return playerSlot + 36;
        }
        return playerSlot;
    }
}

